/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.relic;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.badges.base.RelicBadge;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LogoWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LuckPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PlayerExperiencePlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsFixWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.RelicBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.particles.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.AbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.BigRelicCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.relic.widgets.RelicExperienceWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.init.BadgeRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends Screen
implements IAutoScaledScreen,
IRelicScreenProvider {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;
    private final int backgroundHeight = 256;
    private final int backgroundWidth = 418;

    public RelicDescriptionScreen(Player player, int container, int slot, Screen screen) {
        super((Component)Component.empty());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
    }

    protected void init() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        int x = (this.width - 418) / 2;
        int y = (this.height - 256) / 2;
        this.addRenderableWidget((GuiEventListener)new BigRelicCardWidget(x + 60, y + 47, this));
        this.addRenderableWidget((GuiEventListener)new LogoWidget(x + 313, y + 57, this));
        if (relic.isSomethingWrongWithLevelingPoints(this.stack)) {
            this.addRenderableWidget((GuiEventListener)new PointsFixWidget(x + 330, y + 33, this));
        }
        this.addRenderableWidget((GuiEventListener)new PointsPlateWidget(x + 313, y + 77, this));
        this.addRenderableWidget((GuiEventListener)new PlayerExperiencePlateWidget(x + 313, y + 102, this));
        this.addRenderableWidget((GuiEventListener)new LuckPlateWidget(x + 313, y + 127, this));
        int xOff = 0;
        for (RelicBadge badge : BadgeRegistry.BADGES.getEntries().stream().map(DeferredHolder::get).filter(entry -> entry instanceof RelicBadge).map(entry -> (RelicBadge)entry).toList()) {
            if (!badge.isVisible(this.stack)) continue;
            this.addRenderableWidget((GuiEventListener)new RelicBadgeWidget(x + 270 - xOff, y + 63, (IRelicScreenProvider)this, badge));
            xOff += 15;
        }
        this.addRenderableWidget((GuiEventListener)new RelicExperienceWidget(x + 127, y + 121, this));
        Set<String> abilities = relic.getRelicData().getAbilities().getAbilities().keySet();
        int cardWidth = 32;
        int containerWidth = 209;
        int count = Math.min(5, abilities.size());
        int spacing = cardWidth + 8 + 3 * (5 - count);
        xOff = containerWidth / 2 - (cardWidth * count + (spacing - cardWidth) * Math.max(count - 1, 0)) / 2;
        for (String ability : abilities) {
            this.addRenderableWidget((GuiEventListener)new AbilityCardWidget(x + 77 + xOff, y + 153, this, ability));
            xOff += spacing;
        }
    }

    public void tick() {
        super.tick();
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.minecraft.player, this.slot);
        LocalPlayer player = this.minecraft.player;
        if (player == null || this.stack == null || !(this.stack.getItem() instanceof IRelicItem)) {
            return;
        }
        RandomSource random = player.getRandom();
        int x = (this.width - 418) / 2;
        int y = (this.height - 256) / 2;
        if (player.tickCount % 3 == 0) {
            ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(140, random.nextInt(50), 255), x + 73 + random.nextInt(20), y + 73 + random.nextInt(20), 1.5f + random.nextFloat() * 0.5f, 100 + random.nextInt(50)));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        LocalPlayer player;
        block8: {
            block7: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = this.minecraft.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block7;
                relic = (IRelicItem)item;
                if (player != null) break block8;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        int level = relic.getRelicLevel(this.stack);
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.SPACE_BACKGROUND);
        int x = (this.width - 418) / 2;
        int y = (this.height - 256) / 2;
        int yOff = 0;
        int xOff = 0;
        GUIRenderer.begin(DescriptionTextures.SPACE_BACKGROUND, poseStack).texSize(418, 4096).patternSize(418, 256).pos((float)x + 209.0f, (float)y + 128.0f).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2)).end();
        GUIRenderer.begin(DescriptionTextures.BIG_CARD_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 67, y + 57).end();
        GUIRenderer.begin(DescriptionTextures.TOP_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 60, y + 47).end();
        GUIRenderer.begin(DescriptionTextures.BOTTOM_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 60, y + 133).end();
        int quality = relic.getRelicQuality(this.stack);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + xOff + 64, y + 110).end();
            xOff += 8;
            ++i;
        }
        if (isAliquot) {
            GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + xOff + 64, y + 110).patternSize(4, 7).texSize(8, 7).end();
        }
        poseStack.pushPose();
        float scale = 1.75f;
        poseStack.translate((double)((float)(x + 70) + 8.0f * scale), (double)(y + 69) + Math.sin(((float)player.tickCount + pPartialTick) * 0.1f) * 2.0 + (double)(8.0f * scale), 0.0);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)Math.cos(((float)player.tickCount + pPartialTick) * 0.05f) * 5.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)Math.cos(((float)player.tickCount + pPartialTick) * 0.075f) * 25.0f));
        poseStack.translate(-8.0f * scale, -8.0f * scale, -150.0f * scale);
        poseStack.scale(scale, scale, scale);
        guiGraphics.renderItem(this.stack, 0, 0);
        poseStack.popPose();
        poseStack.pushPose();
        MutableComponent levelComponent = Component.literal((String)String.valueOf(level)).withStyle(ChatFormatting.BOLD);
        poseStack.scale(0.75f, 0.75f, 1.0f);
        guiGraphics.drawString(this.minecraft.font, (Component)levelComponent, (int)(((float)x + 85.5f) * 1.33f - (float)this.minecraft.font.width((FormattedText)levelComponent) / 2.0f), (int)((float)(y + 51) * 1.33f), 16769656, true);
        guiGraphics.drawString(this.minecraft.font, (Component)Component.literal((String)this.stack.getDisplayName().getString().replace("[", "").replace("]", "")).withStyle(ChatFormatting.BOLD), (int)((float)(x + 113) * 1.33f), (int)((float)(y + 67) * 1.33f), 6696723, false);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        yOff = 9;
        for (FormattedCharSequence line : this.minecraft.font.split((FormattedText)Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".description")), 340)) {
            guiGraphics.drawString(this.minecraft.font, line, (x + 112) * 2, (y + 74) * 2 + yOff, 6696723, false);
            yOff += 9;
        }
        poseStack.popPose();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.screen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }

    @Override
    public int getContainer() {
        return this.container;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

