/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.base.AbstractActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class UpgradeActionWidget
extends AbstractActionWidget {
    public UpgradeActionWidget(int x, int y, AbilityDescriptionScreen screen, String ability) {
        super(x, y, PacketRelicTweak.Operation.UPGRADE, screen, ability);
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.getProvider().getStack().getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerUpgrade((Player)this.minecraft.player, this.getProvider().getStack(), this.getAbility());
    }

    @Override
    public void playDownSound(SoundManager handler) {
        Item item = this.getProvider().getStack().getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            if (!this.isLocked()) {
                int level = relic.getAbilityLevel(this.getProvider().getStack(), this.getAbility());
                int maxLevel = relic.getAbilityData(this.getAbility()).getMaxLevel();
                handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.TABLE_UPGRADE.get()), (float)(Screen.hasShiftDown() && relic.mayPlayerUpgrade((Player)this.minecraft.player, this.getProvider().getStack(), this.getAbility()) ? 2.0f : 1.0f + (float)level / (float)maxLevel)));
            }
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item = this.getProvider().getStack().getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        boolean isQuick = Screen.hasShiftDown() && relic.mayPlayerUpgrade((Player)this.minecraft.player, this.getProvider().getStack(), this.getAbility());
        float color = isQuick ? (float)((double)1.05f + Math.sin((float)(this.minecraft.player.tickCount + this.getAbility().length() * 10) * 0.5f) * (double)0.1f) : 1.0f;
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/ability/upgrade_button_" + (this.isLocked() ? "inactive" : "active") + (isQuick ? "_quick" : "") + ".png")), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isHovered) {
            guiGraphics.blit(DescriptionTextures.ACTION_BUTTON_OUTLINE, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        boolean isQuick;
        IRelicItem relic;
        Item item = this.getProvider().getStack().getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isAbilityUnlocked(this.getProvider().getStack(), this.getAbility())) {
            return;
        }
        AbilityData data = relic.getAbilityData(this.getAbility());
        if (data.getStats().isEmpty()) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        PoseStack poseStack = guiGraphics.pose();
        int maxWidth = 100;
        int renderWidth = 0;
        int requiredPoints = data.getRequiredPoints();
        int requiredLevel = relic.getUpgradeRequiredLevel(this.getProvider().getStack(), this.getAbility());
        int points = relic.getRelicLevelingPoints(this.getProvider().getStack());
        int level = this.minecraft.player.experienceLevel;
        MutableComponent negativeStatus = Component.translatable((String)"tooltip.relics.relic.status.negative");
        MutableComponent positiveStatus = Component.translatable((String)"tooltip.relics.relic.status.positive");
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.upgrade.description").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)});
        boolean isMaxLevel = relic.isAbilityMaxLevel(this.getProvider().getStack(), this.getAbility());
        boolean bl = isQuick = Screen.hasShiftDown() && relic.mayPlayerUpgrade((Player)this.minecraft.player, this.getProvider().getStack(), this.getAbility());
        if (!isMaxLevel) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.translatable((String)"tooltip.relics.relic.upgrade.cost", (Object[])new Object[]{isQuick ? Component.literal((String)"XXX").withStyle(ChatFormatting.OBFUSCATED) : Integer.valueOf(requiredPoints), requiredPoints > points ? negativeStatus : positiveStatus, isQuick ? Component.literal((String)"XXX").withStyle(ChatFormatting.OBFUSCATED) : Integer.valueOf(requiredLevel), requiredLevel > level ? negativeStatus : positiveStatus}));
        }
        if (!this.isLocked()) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.upgrade.quick")));
        }
        if (isMaxLevel) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.upgrade.locked")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 5.0f);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (renderX + 10) * 2, (renderY + 9 + yOff) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

