/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcon;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StatWidget
extends AbstractDescriptionWidget {
    private AbilityDescriptionScreen screen;
    private final String stat;

    public StatWidget(int x, int y, AbilityDescriptionScreen screen, String stat) {
        super(x, y, 209, 16);
        this.screen = screen;
        this.stat = stat;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        LocalPlayer player;
        String ability;
        ItemStack stack;
        block10: {
            block9: {
                stack = this.screen.stack;
                ability = this.screen.ability;
                player = this.minecraft.player;
                Item item = stack.getItem();
                if (!(item instanceof IRelicItem)) break block9;
                relic = (IRelicItem)item;
                if (player != null) break block10;
            }
            return;
        }
        StatData statData = relic.getStatData(ability, this.stat);
        PoseStack poseStack = guiGraphics.pose();
        int xOff = 0;
        int yOff = 0;
        poseStack.pushPose();
        StatIcon icon = statData.getIcon();
        Color color = new Color(icon.getColor());
        float blinkOffset = (float)(Math.sin((float)(player.tickCount + this.stat.length() * 10) * 0.2f) * (double)0.1f);
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f + blinkOffset), (float)((float)color.getGreen() / 255.0f + blinkOffset), (float)((float)color.getBlue() / 255.0f + blinkOffset), (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.blit(icon.getPath(), this.getX() + 8, this.getY(), 0.0f, 0.0f, 15, this.height, 15, this.height);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        boolean isLocked = !relic.isAbilityUnlocked(stack, ability);
        boolean isHoveredUpgrade = !isLocked && this.screen.upgradeButton.isHovered();
        boolean isHoveredReroll = !isLocked && this.screen.rerollButton.isHovered();
        boolean isHoveredReset = !isLocked && this.screen.resetButton.isHovered();
        int maxLevel = relic.getAbilityData(ability).getMaxLevel();
        int level = relic.getAbilityLevel(stack, ability);
        MutableComponent cost = Component.literal((String)String.valueOf(statData.getFormatValue().apply(relic.getStatValue(stack, ability, this.stat))));
        if (isHoveredUpgrade && level < maxLevel) {
            cost.append(" \u27a0 " + String.valueOf(statData.getFormatValue().apply(relic.getStatValue(stack, ability, this.stat, level + 1))));
        }
        if (isHoveredReroll) {
            cost.append(" \u27a0 ").append((Component)Component.literal((String)"X.XXX").withStyle(ChatFormatting.OBFUSCATED));
        }
        if (isHoveredReset && level > 0) {
            cost.append(" \u27a0 " + String.valueOf(statData.getFormatValue().apply(relic.getStatValue(stack, ability, this.stat, 0))));
        }
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        guiGraphics.drawString(this.minecraft.font, (Component)Component.translatableWithFallback((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".ability." + ability + ".stat." + this.stat + ".title"), (String)this.stat).withStyle(ChatFormatting.BOLD), (this.getX() + 27) * 2, (this.getY() + 3) * 2, 6696723, false);
        guiGraphics.drawString(this.minecraft.font, (Component)Component.literal((String)"\u25cf ").append((Component)Component.translatableWithFallback((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + ".ability." + ability + ".stat." + this.stat + ".value"), (String)cost.getString(), (Object[])new Object[]{cost})), (this.getX() + 33) * 2, (this.getY() + 9) * 2, 6696723, false);
        poseStack.popPose();
        for (int i = 0; i < 5; ++i) {
            guiGraphics.blit(DescriptionTextures.SMALL_STAR_HOLE, this.getX() + xOff + this.width - 32, this.getY() + yOff + 3, 0.0f, 0.0f, 4, 4, 4, 4);
            xOff += 5;
        }
        xOff = 0;
        int quality = relic.getStatQuality(stack, ability, this.stat);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            guiGraphics.blit(DescriptionTextures.SMALL_STAR_ACTIVE, this.getX() + xOff + this.width - 32, this.getY() + yOff + 3, 0.0f, 0.0f, 4, 4, 4, 4);
            xOff += 5;
            ++i;
        }
        if (isAliquot) {
            guiGraphics.blit(DescriptionTextures.SMALL_STAR_ACTIVE, this.getX() + xOff + this.width - 32, this.getY() + yOff + 3, 0.0f, 0.0f, 2, 4, 4, 4);
        }
        GUIRenderer.begin(DescriptionTextures.STAT_DELIMITER, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(this.getX() + 7, this.getY() + this.height - 2).end();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }
}

