/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.badges.base.AbilityBadge;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.BigAbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.RerollActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.ResetActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.StatWidget;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.UpgradeActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.AbilityBadgeWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LogoWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.LuckPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PlayerExperiencePlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsFixWidget;
import it.hurts.sskirillss.relics.client.screen.description.general.widgets.PointsPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.init.BadgeRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;

@OnlyIn(value=Dist.CLIENT)
public class AbilityDescriptionScreen
extends Screen
implements IAutoScaledScreen,
IRelicScreenProvider {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 256;
    public int backgroundWidth = 418;
    public UpgradeActionWidget upgradeButton;
    public RerollActionWidget rerollButton;
    public ResetActionWidget resetButton;

    public AbilityDescriptionScreen(Player player, int container, int slot, Screen screen, String ability) {
        super((Component)Component.empty());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.ability = ability;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
    }

    protected void init() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new BigAbilityCardWidget(x + 60, y + 47, this, this.ability));
        this.addRenderableWidget((GuiEventListener)new LogoWidget(x + 313, y + 57, this));
        if (relic.isSomethingWrongWithLevelingPoints(this.stack)) {
            this.addRenderableWidget((GuiEventListener)new PointsFixWidget(x + 330, y + 33, this));
        }
        this.addRenderableWidget((GuiEventListener)new PointsPlateWidget(x + 313, y + 77, this));
        this.addRenderableWidget((GuiEventListener)new PlayerExperiencePlateWidget(x + 313, y + 102, this));
        this.addRenderableWidget((GuiEventListener)new LuckPlateWidget(x + 313, y + 127, this));
        int xOff = 0;
        for (AbilityBadge badge : BadgeRegistry.BADGES.getEntries().stream().map(DeferredHolder::get).filter(entry -> entry instanceof AbilityBadge).map(entry -> (AbilityBadge)entry).toList()) {
            if (!badge.isVisible(this.stack, this.ability)) continue;
            this.addRenderableWidget((GuiEventListener)new AbilityBadgeWidget(x + 270 - xOff, y + 63, this, badge, this.ability));
            xOff += 15;
        }
        int yOff = 0;
        for (Map.Entry<String, StatData> entry2 : relic.getAbilityData(this.ability).getStats().entrySet()) {
            this.addRenderableWidget((GuiEventListener)new StatWidget(x + 77, y + yOff + 148, this, entry2.getKey()));
            yOff += 14;
        }
        this.upgradeButton = (UpgradeActionWidget)this.addRenderableWidget((GuiEventListener)new UpgradeActionWidget(x + 288, y + 152, this, this.ability));
        this.rerollButton = (RerollActionWidget)this.addRenderableWidget((GuiEventListener)new RerollActionWidget(x + 288, y + 170, this, this.ability));
        this.resetButton = (ResetActionWidget)this.addRenderableWidget((GuiEventListener)new ResetActionWidget(x + 288, y + 188, this, this.ability));
    }

    public void tick() {
        super.tick();
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.minecraft.player, this.slot);
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        LocalPlayer player;
        block8: {
            block7: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                player = this.minecraft.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block7;
                relic = (IRelicItem)item;
                if (player != null) break block8;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        int level = relic.getAbilityLevel(this.stack, this.ability);
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.SPACE_BACKGROUND);
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        int yOff = 0;
        int xOff = 0;
        GUIRenderer.begin(DescriptionTextures.SPACE_BACKGROUND, poseStack).texSize(418, 4096).patternSize(this.backgroundWidth, this.backgroundHeight).pos((float)x + (float)this.backgroundWidth / 2.0f, (float)y + (float)this.backgroundHeight / 2.0f).animation(AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2)).end();
        float color = (float)((double)1.05f + Math.sin((float)(player.tickCount + this.ability.length() * 10) * 0.2f) * (double)0.1f);
        GUIRenderer.begin(DescriptionTextures.getAbilityCardTexture(this.stack, this.ability), poseStack).anchor(SpriteAnchor.TOP_LEFT).color(color, color, color, 1.0f).pos(x + 67, y + 57).texSize(34, 49).end();
        GUIRenderer.begin(DescriptionTextures.TOP_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 60, y + 47).end();
        GUIRenderer.begin(DescriptionTextures.BOTTOM_BACKGROUND, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + 60, y + 133).end();
        int quality = relic.getAbilityQuality(this.stack, this.ability);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + xOff + 64, y + 110).end();
            xOff += 8;
            ++i;
        }
        if (isAliquot) {
            GUIRenderer.begin(DescriptionTextures.BIG_STAR_ACTIVE, poseStack).anchor(SpriteAnchor.TOP_LEFT).pos(x + xOff + 64, y + 110).patternSize(4, 7).texSize(8, 7).end();
        }
        poseStack.pushPose();
        MutableComponent pointsComponent = Component.literal((String)String.valueOf(level)).withStyle(ChatFormatting.BOLD);
        poseStack.scale(0.75f, 0.75f, 1.0f);
        guiGraphics.drawString(this.minecraft.font, (Component)pointsComponent, (int)(((float)x + 85.5f) * 1.33f - (float)this.minecraft.font.width((FormattedText)pointsComponent) / 2.0f), (int)((float)(y + 51) * 1.33f), 16769656, true);
        guiGraphics.drawString(this.minecraft.font, (Component)Component.translatableWithFallback((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + this.ability), (String)this.ability).withStyle(ChatFormatting.BOLD), (int)((float)(x + 113) * 1.33f), (int)((float)(y + 67) * 1.33f), 6696723, false);
        yOff = 9;
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence line : this.minecraft.font.split((FormattedText)Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + ".ability." + this.ability + ".description")), 340)) {
            guiGraphics.drawString(this.minecraft.font, line, (x + 112) * 2, (y + 74) * 2 + yOff, 6696723, false);
            yOff += 9;
        }
        poseStack.popPose();
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new RelicDescriptionScreen((Player)this.minecraft.player, this.container, this.slot, this.screen));
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }

    @Override
    public int getContainer() {
        return this.container;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

