/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BasicColoredParticle
extends TextureSheetParticle {
    private final Constructor constructor;
    private static final ParticleRenderType RENDERER = new ParticleRenderType(){

        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.depthMask((boolean)false);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "relics:basic_colored";
        }
    };

    public BasicColoredParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Constructor constructor) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.setColor((float)constructor.getColor().getRed() / 255.0f, (float)constructor.getColor().getGreen() / 255.0f, (float)constructor.getColor().getBlue() / 255.0f);
        this.setSize(constructor.getDiameter(), constructor.getDiameter());
        this.setAlpha((float)constructor.getColor().getAlpha() / 255.0f);
        this.setLifetime(constructor.getLifetime());
        this.constructor = constructor;
        this.quadSize = constructor.getDiameter();
        this.hasPhysics = constructor.isPhysical();
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
    }

    public void tick() {
        this.quadSize *= this.constructor.getScaleModifier();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.oRoll = this.roll;
        this.roll += this.constructor.getRoll();
        this.move(this.xd, this.yd, this.zd);
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return RENDERER;
    }

    public static class Constructor {
        private Color color;
        private float diameter;
        private float roll;
        private boolean physical;
        private int lifetime;
        private float scaleModifier;

        private static float $default$diameter() {
            return 1.0f;
        }

        private static float $default$roll() {
            return 0.0f;
        }

        private static boolean $default$physical() {
            return true;
        }

        private static int $default$lifetime() {
            return 20;
        }

        private static float $default$scaleModifier() {
            return 1.0f;
        }

        Constructor(Color color, float diameter, float roll, boolean physical, int lifetime, float scaleModifier) {
            this.color = color;
            this.diameter = diameter;
            this.roll = roll;
            this.physical = physical;
            this.lifetime = lifetime;
            this.scaleModifier = scaleModifier;
        }

        public static ConstructorBuilder builder() {
            return new ConstructorBuilder();
        }

        public Color getColor() {
            return this.color;
        }

        public float getDiameter() {
            return this.diameter;
        }

        public float getRoll() {
            return this.roll;
        }

        public boolean isPhysical() {
            return this.physical;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setDiameter(float diameter) {
            this.diameter = diameter;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }

        public void setPhysical(boolean physical) {
            this.physical = physical;
        }

        public void setLifetime(int lifetime) {
            this.lifetime = lifetime;
        }

        public void setScaleModifier(float scaleModifier) {
            this.scaleModifier = scaleModifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constructor)) {
                return false;
            }
            Constructor other = (Constructor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getDiameter(), other.getDiameter()) != 0) {
                return false;
            }
            if (Float.compare(this.getRoll(), other.getRoll()) != 0) {
                return false;
            }
            if (this.isPhysical() != other.isPhysical()) {
                return false;
            }
            if (this.getLifetime() != other.getLifetime()) {
                return false;
            }
            if (Float.compare(this.getScaleModifier(), other.getScaleModifier()) != 0) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Constructor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getDiameter());
            result = result * 59 + Float.floatToIntBits(this.getRoll());
            result = result * 59 + (this.isPhysical() ? 79 : 97);
            result = result * 59 + this.getLifetime();
            result = result * 59 + Float.floatToIntBits(this.getScaleModifier());
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            return result;
        }

        public String toString() {
            return "BasicColoredParticle.Constructor(color=" + String.valueOf(this.getColor()) + ", diameter=" + this.getDiameter() + ", roll=" + this.getRoll() + ", physical=" + this.isPhysical() + ", lifetime=" + this.getLifetime() + ", scaleModifier=" + this.getScaleModifier() + ")";
        }

        public static class ConstructorBuilder {
            private boolean diameter$set;
            private float diameter$value;
            private boolean roll$set;
            private float roll$value;
            private boolean physical$set;
            private boolean physical$value;
            private boolean lifetime$set;
            private int lifetime$value;
            private boolean scaleModifier$set;
            private float scaleModifier$value;
            private Color color = new Color(-1, true);

            public ConstructorBuilder color(int color) {
                this.color = new Color(color, true);
                return this;
            }

            public ConstructorBuilder color(float r, float g, float b, float a) {
                return this.color(new Color(r, g, b, a).getRGB());
            }

            public ConstructorBuilder color(float r, float g, float b) {
                return this.color(r, g, b, 1.0f);
            }

            public ConstructorBuilder color(int r, int g, int b, int a) {
                return this.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
            }

            public ConstructorBuilder color(int r, int g, int b) {
                return this.color(r, g, b, 255);
            }

            ConstructorBuilder() {
            }

            public ConstructorBuilder diameter(float diameter) {
                this.diameter$value = diameter;
                this.diameter$set = true;
                return this;
            }

            public ConstructorBuilder roll(float roll) {
                this.roll$value = roll;
                this.roll$set = true;
                return this;
            }

            public ConstructorBuilder physical(boolean physical) {
                this.physical$value = physical;
                this.physical$set = true;
                return this;
            }

            public ConstructorBuilder lifetime(int lifetime) {
                this.lifetime$value = lifetime;
                this.lifetime$set = true;
                return this;
            }

            public ConstructorBuilder scaleModifier(float scaleModifier) {
                this.scaleModifier$value = scaleModifier;
                this.scaleModifier$set = true;
                return this;
            }

            public Constructor build() {
                float diameter$value = this.diameter$value;
                if (!this.diameter$set) {
                    diameter$value = Constructor.$default$diameter();
                }
                float roll$value = this.roll$value;
                if (!this.roll$set) {
                    roll$value = Constructor.$default$roll();
                }
                boolean physical$value = this.physical$value;
                if (!this.physical$set) {
                    physical$value = Constructor.$default$physical();
                }
                int lifetime$value = this.lifetime$value;
                if (!this.lifetime$set) {
                    lifetime$value = Constructor.$default$lifetime();
                }
                float scaleModifier$value = this.scaleModifier$value;
                if (!this.scaleModifier$set) {
                    scaleModifier$value = Constructor.$default$scaleModifier();
                }
                return new Constructor(this.color, diameter$value, roll$value, physical$value, lifetime$value, scaleModifier$value);
            }

            public String toString() {
                return "BasicColoredParticle.Constructor.ConstructorBuilder(color=" + String.valueOf(this.color) + ", diameter$value=" + this.diameter$value + ", roll$value=" + this.roll$value + ", physical$value=" + this.physical$value + ", lifetime$value=" + this.lifetime$value + ", scaleModifier$value=" + this.scaleModifier$value + ")";
            }
        }
    }

    public static class Type
    extends ParticleType<Options> {
        public Type() {
            super(false);
        }

        public MapCodec<Options> codec() {
            return Options.CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, Options> streamCodec() {
            return Options.STREAM_CODEC;
        }
    }

    public static class Factory
    implements ParticleProvider<Options> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(Options options, ClientLevel world, double xPos, double yPos, double zPos, double xVelocity, double yVelocity, double zVelocity) {
            BasicColoredParticle particle = new BasicColoredParticle(world, xPos, yPos, zPos, xVelocity, yVelocity, zVelocity, options.getData());
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    public static class Options
    implements ParticleOptions {
        private final Constructor data;
        public static final MapCodec<Options> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(options -> options.getData().getColor().getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(options -> Float.valueOf(options.getData().getDiameter())), (App)Codec.INT.fieldOf("lifetime").forGetter(options -> options.getData().getLifetime()), (App)Codec.FLOAT.fieldOf("roll").forGetter(options -> Float.valueOf(options.getData().getRoll())), (App)Codec.FLOAT.fieldOf("scaleModifier").forGetter(options -> Float.valueOf(options.getData().getScaleModifier()))).apply((Applicative)instance, Options::new));
        public static final StreamCodec<ByteBuf, Options> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, options -> options.getData().getColor().getRGB(), (StreamCodec)ByteBufCodecs.FLOAT, options -> Float.valueOf(options.getData().getDiameter()), (StreamCodec)ByteBufCodecs.INT, options -> options.getData().getLifetime(), (StreamCodec)ByteBufCodecs.FLOAT, options -> Float.valueOf(options.getData().getRoll()), (StreamCodec)ByteBufCodecs.FLOAT, options -> Float.valueOf(options.getData().getScaleModifier()), Options::new);

        private Options(int color, float diameter, int lifetime, float roll, float scaleModifier) {
            this.data = Constructor.builder().color(color).diameter(diameter).lifetime(lifetime).roll(roll).scaleModifier(scaleModifier).build();
        }

        public Options(Constructor data) {
            this.data = data;
        }

        @Nonnull
        public ParticleType<Options> getType() {
            return (ParticleType)ParticleRegistry.BASIC_COLORED.get();
        }

        public Constructor getData() {
            return this.data;
        }
    }
}

