/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.handlers;

import com.mojang.blaze3d.platform.Window;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.relic.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class DescriptionHandler {
    private static final int REQUIRED_TIME = 20;
    private static int ticksCount;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            return;
        }
        boolean hasShiftDown = Screen.hasShiftDown();
        if (ticksCount > 0 && !hasShiftDown) {
            --ticksCount;
        }
        Minecraft MC = Minecraft.getInstance();
        Screen screen = MC.screen;
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        Window window = MC.getWindow();
        double mouseX = MC.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double mouseY = MC.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        AbstractContainerMenu menu = player.containerMenu;
        Slot slot = null;
        int id = 0;
        for (int i = 0; i < menu.slots.size(); ++i) {
            Slot entry = (Slot)menu.slots.get(i);
            if (!DescriptionHandler.isHovering(screen2.getGuiLeft(), screen2.getGuiTop(), entry.x, entry.y, mouseX, mouseY)) continue;
            slot = entry;
            id = i;
            break;
        }
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.getItem();
        if (!(stack.getItem() instanceof IRelicItem)) {
            return;
        }
        if (hasShiftDown && ++ticksCount >= 20) {
            RelicDescriptionScreen descriptionScreen = new RelicDescriptionScreen(player, player.containerMenu.containerId, id, Minecraft.getInstance().screen);
            descriptionScreen.stack = DescriptionUtils.gatherRelicStack(player, id);
            Minecraft.getInstance().setScreen((Screen)descriptionScreen);
            ticksCount = 0;
        }
    }

    protected static boolean isHovering(int leftPos, int topPos, int slotX, int slotY, double mouseX, double mouseY) {
        return (mouseX -= (double)leftPos) >= (double)(slotX - 1) && mouseX < (double)(slotX + 16 + 1) && (mouseY -= (double)topPos) >= (double)(slotY - 1) && mouseY < (double)(slotY + 16 + 1);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!(event.getItemStack().getItem() instanceof IRelicItem)) {
            return;
        }
        event.getToolTip().add(DescriptionHandler.drawProgressBar("||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||"));
    }

    public static MutableComponent drawProgressBar(String style) {
        StringBuilder string = new StringBuilder(style);
        float percentage = (float)ticksCount / 20.0f;
        int offset = (int)Math.min((double)string.length(), Math.floor((float)string.length() * percentage));
        MutableComponent component = Component.literal((String)"");
        String start = string.substring(0, offset);
        int startColor = 1573171;
        int endColor = 2885731;
        for (int i = 0; i < offset; ++i) {
            float fraction = (float)i / (float)(offset - 1);
            int r = (int)((1.0f - fraction) * (float)(startColor >> 16 & 0xFF) + fraction * (float)(endColor >> 16 & 0xFF));
            int g = (int)((1.0f - fraction) * (float)(startColor >> 8 & 0xFF) + fraction * (float)(endColor >> 8 & 0xFF));
            int b = (int)((1.0f - fraction) * (float)(startColor & 0xFF) + fraction * (float)(endColor & 0xFF));
            int color = r << 16 | g << 8 | b;
            component.append((Component)Component.literal((String)String.valueOf(start.charAt(i))).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)color))));
        }
        component.append((Component)Component.literal((String)string.substring(offset)).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
        return component;
    }
}

