/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.crafting.processoverride;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingProcessOverrideBrewingStand
implements ICraftingProcessOverride {
    private static final Direction SIDE_INGREDIENT = Direction.UP;
    private static final Direction SIDE_BOTTLE = Direction.NORTH;

    @Override
    public boolean isApplicable(PartPos target) {
        return this.getTile(target).isPresent();
    }

    @Nullable
    private Optional<BrewingStandBlockEntity> getTile(PartPos target) {
        return BlockEntityHelpers.get((DimPos)target.getPos(), BrewingStandBlockEntity.class);
    }

    @Override
    public boolean craft(Function<IngredientComponent<?, ?>, PartPos> targetGetter, IMixedIngredients ingredients, ICraftingResultsSink resultsSink, boolean simulate) {
        List instances = ingredients.getInstances(IngredientComponent.ITEMSTACK);
        if (instances.size() != 4 || ingredients.getComponents().size() != 1) {
            return false;
        }
        return this.getTile(targetGetter.apply(IngredientComponent.ITEMSTACK)).map(tile -> {
            IItemHandler ingredientHandler = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), (BlockEntity)tile, (Object)SIDE_INGREDIENT);
            IItemHandler bottleHandler = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), (BlockEntity)tile, (Object)SIDE_BOTTLE);
            if (ingredientHandler != null && bottleHandler != null) {
                int ingredientSlotIndex = 0;
                int bottleSlotIndex = 0;
                for (ItemStack instance : instances) {
                    if (!(tile.getLevel().potionBrewing().isIngredient(instance) ? !ingredientHandler.insertItem(ingredientSlotIndex++, instance, simulate).isEmpty() : !bottleHandler.insertItem(bottleSlotIndex++, instance, simulate).isEmpty())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }).orElse(false);
    }
}

