/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.block.entity.OnLoadHandler;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.WaystoneEditMenu;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity
implements OnLoadHandler,
CustomRenderBoundingBox,
BalmContainerProvider {
    protected final DefaultContainer container = new DefaultContainer(5){

        public int getMaxStackSize(ItemStack itemStack) {
            if (itemStack.is(ModItems.dormantShard)) {
                return 1;
            }
            return super.getMaxStackSize(itemStack);
        }

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (itemStack.is(ModItems.dormantShard)) {
                return slot == 0;
            }
            return super.canPlaceItem(slot, itemStack);
        }

        public void setChanged() {
            WaystoneBlockEntityBase.this.onInventoryChanged();
        }
    };
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    protected void onInventoryChanged() {
    }

    public WaystoneBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("Items", (Tag)this.container.serialize(provider));
        if (this.waystone.isValid()) {
            tag.put("UUID", (Tag)NbtUtils.createUUID((UUID)this.waystone.getWaystoneUid()));
        } else if (this.waystoneUid != null) {
            tag.put("UUID", (Tag)NbtUtils.createUUID((UUID)this.waystoneUid));
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Items")) {
            this.container.deserialize(compound.getCompound("Items"), provider);
        }
        if (compound.contains("UUID", 11)) {
            this.waystoneUid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("UUID")));
        }
        if (compound.contains("Waystone", 10)) {
            Waystone syncedWaystone = WaystoneImpl.read(compound.getCompound("Waystone"), provider);
            WaystoneManagerImpl.get(null).updateWaystone(syncedWaystone);
            this.waystone = new WaystoneProxy(null, syncedWaystone.getWaystoneUid());
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        UUID waystoneUidComponent = (UUID)input.get((DataComponentType)ModComponents.waystone.get());
        if (waystoneUidComponent != null) {
            this.waystoneUid = waystoneUidComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set((DataComponentType)ModComponents.waystone.get(), (Object)(this.waystone.isValid() ? this.waystone.getWaystoneUid() : this.waystoneUid));
    }

    public void writeUpdateTag(CompoundTag tag) {
        tag.put("Waystone", (Tag)WaystoneImpl.write(this.getWaystone(), new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.level != null) {
            ((WaystoneImpl)backingWaystone).setDimension((ResourceKey<Level>)this.level.dimension());
            ((WaystoneImpl)backingWaystone).setPos(this.worldPosition);
        }
        this.sync();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.level == null || this.level.isClientSide || this.shouldNotInitialize)) {
            BlockState state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.level.getServer(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.getBlockState()).getBlock() instanceof WaystoneBlockBase) {
                BlockEntity blockEntity;
                WaystoneOrigin origin;
                DoubleBlockHalf half = state.hasProperty(WaystoneBlockBase.HALF) ? (DoubleBlockHalf)state.getValue(WaystoneBlockBase.HALF) : DoubleBlockHalf.LOWER;
                WaystoneOrigin waystoneOrigin = origin = state.hasProperty(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.getValue(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == DoubleBlockHalf.LOWER) {
                    this.initializeWaystone((ServerLevelAccessor)Objects.requireNonNull(this.level), null, origin);
                } else if (half == DoubleBlockHalf.UPPER && (blockEntity = this.level.getBlockEntity(this.worldPosition.below())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.sync();
            }
        }
        return this.waystone;
    }

    protected abstract ResourceLocation getWaystoneType();

    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (ResourceKey<Level>)world.getLevel().dimension(), this.worldPosition, origin, player != null ? player.getUUID() : null);
        WaystoneManagerImpl.get(world.getServer()).addWaystone(waystone);
        this.waystone = waystone;
        this.setChanged();
        this.sync();
    }

    public void initializeFromExisting(ServerLevelAccessor world, WaystoneImpl existingWaystone, ItemStack itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((ResourceKey<Level>)world.getLevel().dimension());
        existingWaystone.setPos(this.worldPosition);
        existingWaystone.setTransient(false);
        WaystoneManagerImpl.get(world.getServer()).updateWaystone(this.waystone);
        this.setChanged();
        this.sync();
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.setChanged();
        this.sync();
    }

    public void uninitializeWaystone() {
        if (this.waystone.isValid()) {
            WaystoneManagerImpl.get(this.level.getServer()).removeWaystone(this.waystone);
            PlayerWaystoneManager.removeKnownWaystone(this.level.getServer(), this.waystone);
            WaystoneSyncManager.sendWaystoneRemovalToAll(this.level.getServer(), this.waystone, true);
        }
        this.waystone = InvalidWaystone.INSTANCE;
        this.shouldNotInitialize = true;
        DoubleBlockHalf half = (DoubleBlockHalf)this.getBlockState().getValue((Property)WaystoneBlock.HALF);
        BlockPos otherPos = half == DoubleBlockHalf.UPPER ? this.worldPosition.below() : this.worldPosition.above();
        BlockEntity blockEntity = Objects.requireNonNull(this.level).getBlockEntity(otherPos);
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
            waystoneTile.waystone = InvalidWaystone.INSTANCE;
            waystoneTile.shouldNotInitialize = true;
        }
        this.setChanged();
        this.sync();
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public Optional<MenuProvider> getSelectionMenuProvider() {
        return Optional.empty();
    }

    public abstract Component getName();

    public Optional<MenuProvider> getSettingsMenuProvider() {
        return Optional.of(new BalmMenuProvider<WaystoneEditMenu.Data>(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.waystones.waystone_settings", (Object[])new Object[]{WaystoneBlockEntityBase.this.getName()});
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, player.level(), WaystoneBlockEntityBase.this.getWaystone());
                return new WaystoneEditMenu(i, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this, playerInventory, WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(Component::translatable).orElse(null));
            }

            public WaystoneEditMenu.Data getScreenOpeningData(ServerPlayer serverPlayer) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((Player)serverPlayer, serverPlayer.level(), WaystoneBlockEntityBase.this.getWaystone());
                return new WaystoneEditMenu.Data(WaystoneBlockEntityBase.this.worldPosition, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(Component::translatable));
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneEditMenu.Data> getScreenStreamCodec() {
                return WaystoneEditMenu.STREAM_CODEC;
            }
        });
    }

    public Optional<MenuProvider> getModifierMenuProvider() {
        return Optional.of(new BalmMenuProvider<BlockPos>(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.waystones.waystone_modifiers");
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                return new WaystoneModifierMenu(i, WaystoneBlockEntityBase.this, playerInventory);
            }

            public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
                return WaystoneBlockEntityBase.this.worldPosition;
            }

            public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
                return BlockPos.STREAM_CODEC.cast();
            }
        });
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack item = this.container.getItem(i);
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public Container getContainer() {
        return this.container;
    }

    public void applyModifierEffects(Entity entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<ItemStack> curativeItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack itemStack = this.container.getItem(i);
            if (itemStack.getItem() == Items.BLAZE_POWDER) {
                fireSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.POISONOUS_POTATO) {
                poisonSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.INK_SAC) {
                blindSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.MILK_BUCKET || itemStack.getItem() == Items.HONEY_BLOCK) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.getItem() == Items.DIAMOND) {
                potency = Math.min(4, potency + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() == Items.FEATHER) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() == Items.MAGMA_CREAM) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() != Items.WITHER_ROSE) continue;
            witherSeconds += itemStack.getCount();
        }
        if (entity instanceof LivingEntity) {
            if (fireSeconds > 0) {
                entity.setRemainingFireTicks(fireSeconds * 20);
            }
            if (poisonSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.WITHER, witherSeconds * 20, potency));
            }
            for (ItemStack curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((LivingEntity)entity, curativeItem);
            }
        }
    }

    private int getModifierCount() {
        int modifiers = 0;
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack itemStack = this.container.getItem(i);
            if (itemStack.getItem() == Items.BLAZE_POWDER) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.POISONOUS_POTATO) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.INK_SAC) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.MILK_BUCKET || itemStack.getItem() == Items.HONEY_BLOCK) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.DIAMOND) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.FEATHER) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.MAGMA_CREAM) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.WITHER_ROSE) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.QUARTZ) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() != Items.SPIDER_EYE) continue;
            ++modifiers;
        }
        return modifiers;
    }
}

