/*
 * Decompiled with CFR 0.152.
 */
package com.slaincow.factoryblocks.block;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.slaincow.factoryblocks.TooltipBlockItem;
import com.slaincow.factoryblocks.block.BaseFactoryBlock;
import com.slaincow.factoryblocks.block.fan.BaseFanBlock;
import com.slaincow.factoryblocks.block.fan.MediumFanBlock;
import com.slaincow.factoryblocks.block.fan.RedstoneFanBlock;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class RegisterBlocks {
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"factory_blocks"));
    public static ArrayList<RegistrySupplier<Item>> itemSuppliers = new ArrayList();

    private static void addFactoryBlock(String nameID, Type type) {
        RegisterBlocks.addFactoryBlock(nameID, type, true);
    }

    private static void addFactoryBlock(String nameID, Type type, boolean include) {
        ResourceLocation blockID = ResourceLocation.fromNamespaceAndPath((String)"factory_blocks", (String)nameID);
        Registrar blocks = ((RegistrarManager)MANAGER.get()).get((Registry)BuiltInRegistries.BLOCK);
        RegistrySupplier blockSupplier = switch (type.ordinal()) {
            default -> blocks.register(blockID, () -> new BaseFactoryBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
            case 1 -> blocks.register(blockID, () -> new BaseFanBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
            case 2 -> blocks.register(blockID, () -> new RedstoneFanBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
            case 3 -> blocks.register(blockID, () -> new MediumFanBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
        };
        Registrar items = ((RegistrarManager)MANAGER.get()).get((Registry)BuiltInRegistries.ITEM);
        itemSuppliers.add((RegistrySupplier<Item>)items.register(blockID, () -> new TooltipBlockItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(CreativeModeTabs.BUILDING_BLOCKS), nameID + ".tooltip")));
    }

    public static void register() {
        RegisterBlocks.addFactoryBlock("factory", Type.base);
        RegisterBlocks.addFactoryBlock("rust", Type.base);
        RegisterBlocks.addFactoryBlock("vrust", Type.base);
        RegisterBlocks.addFactoryBlock("srust", Type.base);
        RegisterBlocks.addFactoryBlock("wireframe", Type.base);
        RegisterBlocks.addFactoryBlock("pwireframe", Type.base);
        RegisterBlocks.addFactoryBlock("hazard", Type.base);
        RegisterBlocks.addFactoryBlock("hazardo", Type.base);
        RegisterBlocks.addFactoryBlock("circuit", Type.base);
        RegisterBlocks.addFactoryBlock("metalbox", Type.base);
        RegisterBlocks.addFactoryBlock("gcircuit", Type.base);
        RegisterBlocks.addFactoryBlock("pgcircuit", Type.base);
        RegisterBlocks.addFactoryBlock("grinder", Type.base);
        RegisterBlocks.addFactoryBlock("old_vents", Type.base);
        RegisterBlocks.addFactoryBlock("rust_plates", Type.base);
        RegisterBlocks.addFactoryBlock("bcircuit", Type.base);
        RegisterBlocks.addFactoryBlock("ice", Type.base);
        RegisterBlocks.addFactoryBlock("mosaic", Type.base);
        RegisterBlocks.addFactoryBlock("bwireframe", Type.base);
        RegisterBlocks.addFactoryBlock("rusty_scaffold", Type.base);
        RegisterBlocks.addFactoryBlock("caution", Type.base);
        RegisterBlocks.addFactoryBlock("large_pipes", Type.base);
        RegisterBlocks.addFactoryBlock("small_pipes", Type.base);
        RegisterBlocks.addFactoryBlock("vent", Type.base);
        RegisterBlocks.addFactoryBlock("gvent", Type.base);
        RegisterBlocks.addFactoryBlock("insulation", Type.base);
        RegisterBlocks.addFactoryBlock("gears", Type.base);
        RegisterBlocks.addFactoryBlock("cables", Type.base);
        RegisterBlocks.addFactoryBlock("rust_bplates", Type.base);
        RegisterBlocks.addFactoryBlock("grate", Type.base);
        RegisterBlocks.addFactoryBlock("rgrate", Type.base);
        RegisterBlocks.addFactoryBlock("hex", Type.base);
        RegisterBlocks.addFactoryBlock("wgpanel", Type.base);
        RegisterBlocks.addFactoryBlock("wopanel", Type.base);
        RegisterBlocks.addFactoryBlock("sturdy", Type.base);
        RegisterBlocks.addFactoryBlock("megacell", Type.base);
        RegisterBlocks.addFactoryBlock("exhaust", Type.base);
        RegisterBlocks.addFactoryBlock("engineer", Type.base);
        RegisterBlocks.addFactoryBlock("scaffold", Type.base);
        RegisterBlocks.addFactoryBlock("piping", Type.base);
        RegisterBlocks.addFactoryBlock("large_plating", Type.base);
        RegisterBlocks.addFactoryBlock("fan_side", Type.base);
        RegisterBlocks.addFactoryBlock("fan_on", Type.baseFan);
        RegisterBlocks.addFactoryBlock("fan_four_on", Type.baseFan);
        RegisterBlocks.addFactoryBlock("fan_malfunction_on", Type.baseFan);
        RegisterBlocks.addFactoryBlock("fan", Type.redFan);
        RegisterBlocks.addFactoryBlock("fan_four", Type.redFan);
        RegisterBlocks.addFactoryBlock("fan_malfunction", Type.redFan);
        RegisterBlocks.addFactoryBlock("medium_fan", Type.mediumFan, false);
    }

    static enum Type {
        base,
        baseFan,
        redFan,
        mediumFan;

    }
}

