/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.mixin.features.notoast;

import dev.ftb.packcompanion.config.PCClientConfig;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.tutorial.TutorialStepInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Tutorial.class})
public abstract class TutorialMixin {
    @Shadow
    @Nullable
    private TutorialStepInstance instance;

    @Shadow
    public abstract void stop();

    @Inject(at={@At(value="HEAD")}, method={"start()V"}, cancellable=true)
    private void start(CallbackInfo info) {
        if (TutorialMixin.enabled()) {
            if (this.instance != null) {
                this.stop();
            }
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"}, cancellable=true)
    private void tick(CallbackInfo info) {
        if (TutorialMixin.enabled()) {
            info.cancel();
        }
    }

    private static boolean enabled() {
        return (Boolean)PCClientConfig.DISABLE_TUTORIAL_TOASTS.get();
    }
}

