/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.packcompanion.PackCompanionExpectPlatform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public interface PCCommonConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbpc-common");
    public static final BooleanValue BREAK_LIGHT_SOURCES_NEAR_SPAWNERS = (BooleanValue)CONFIG.addBoolean("break_light_sources_near_spawners", false).comment(new String[]{"When enabled, light sources near spawners will be broken to allow for mob spawning."});
    public static final BooleanValue IGNORE_LIGHT_LEVEL_FOR_SPAWNERS = (BooleanValue)CONFIG.addBoolean("ignore_light_level_for_spawners", false).comment(new String[]{"When enabled, the light level around spawners will be ignored for mob spawning."});
    public static final SparseStructuresValue SPARSE_STRUCTURES = (SparseStructuresValue)CONFIG.add((BaseValue)new SparseStructuresValue(CONFIG, "sparse_structures", SparseStructuresConfig.DEFAULT));

    public static void load() {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)PackCompanionExpectPlatform.getConfigDirectory(), (String)"ftbpc");
    }

    public static class SparseStructuresValue
    extends BaseValue<SparseStructuresConfig> {
        protected SparseStructuresValue(@Nullable SNBTConfig c, String n, SparseStructuresConfig def) {
            super(c, n, (Object)def);
        }

        public void write(SNBTCompoundTag compoundTag) {
            SNBTCompoundTag tag = new SNBTCompoundTag();
            tag.comment("enabled", "Whether sparse structures are enabled.");
            tag.putBoolean("enabled", ((SparseStructuresConfig)this.get()).enabled);
            tag.comment("global_spread_factor", "The global spread factor for all structures when no custom spread factor is defined.");
            tag.putDouble("global_spread_factor", ((SparseStructuresConfig)this.get()).globalSpreadFactor);
            ListTag list = new ListTag();
            for (CustomSpreadFactors custom : ((SparseStructuresConfig)this.get()).customSpreadFactors) {
                SNBTCompoundTag customTag = new SNBTCompoundTag();
                customTag.putString("structure", custom.structure);
                customTag.putDouble("spread_factor", custom.spreadFactor);
                list.add((Object)customTag);
            }
            tag.comment("custom_spread_factors", "Custom spread factors for specific structures.");
            tag.put("custom_spread_factors", (Tag)list);
            compoundTag.comment(this.key, "Sparse structures configuration. See https://github.com/MCTeamPotato/SparseStructuresReforged/tree/1201 for more information.");
            compoundTag.put(this.key, (Tag)tag);
        }

        public void read(SNBTCompoundTag parent) {
            if (!parent.contains(this.key)) {
                this.set(SparseStructuresConfig.DEFAULT);
                return;
            }
            SNBTCompoundTag tag = (SNBTCompoundTag)parent.get(this.key);
            if (tag == null) {
                this.set(SparseStructuresConfig.DEFAULT);
                return;
            }
            boolean enabled = tag.getBoolean("enabled");
            double globalSpreadFactor = tag.getDouble("global_spread_factor");
            ArrayList<CustomSpreadFactors> customSpreadFactors = new ArrayList<CustomSpreadFactors>();
            if (tag.contains("custom_spread_factors")) {
                ListTag listTag = tag.getList("custom_spread_factors", 10);
                for (Tag customTag : listTag) {
                    SNBTCompoundTag compound = (SNBTCompoundTag)customTag;
                    customSpreadFactors.add(new CustomSpreadFactors(compound.getString("structure"), compound.getDouble("spread_factor")));
                }
            }
            this.set(new SparseStructuresConfig(enabled, globalSpreadFactor, customSpreadFactors));
        }
    }

    public record SparseStructuresConfig(boolean enabled, double globalSpreadFactor, List<CustomSpreadFactors> customSpreadFactors) {
        public static final SparseStructuresConfig DEFAULT = new SparseStructuresConfig(false, 2.0, new ArrayList<CustomSpreadFactors>());
    }

    public record CustomSpreadFactors(String structure, double spreadFactor) {
    }
}

