/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.packcompanion.PackCompanionExpectPlatform;
import java.nio.file.Path;

public interface PCClientConfig {
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbpc-client");
    public static final BooleanValue DISABLE_TUTORIAL_TOASTS = (BooleanValue)CONFIG.addBoolean("disable_tutorial_toasts", true).comment(new String[]{"When enabled, toasts regarding the in-game start tutorial will be disabled."});
    public static final BooleanValue DISABLE_ADVANCEMENT_TOASTS = (BooleanValue)CONFIG.addBoolean("disable_advancements_toasts", false).comment(new String[]{"When enabled, toasts regarding the advancement progression will be disabled."});
    public static final BooleanValue DISABLE_RECIPE_TOASTS = (BooleanValue)CONFIG.addBoolean("disable_recipe_toasts", false).comment(new String[]{"When enabled, toasts regarding the recipe unlocks will be disabled."});
    public static final BooleanValue WORLD_USES_STATIC_SEED = (BooleanValue)CONFIG.addBoolean("world_uses_static_seed", false).comment(new String[]{"When enabled, the world will always use the same seed, regardless of the world name."});
    public static final StringValue STATIC_SEED = (StringValue)CONFIG.addString("static_seed", "").comment(new String[]{"The seed to use for the world. Only used if world_uses_static_seed is enabled."});
    public static final BooleanValue REMOVE_ADVANCEMENTS_FROM_PAUSE = (BooleanValue)CONFIG.addBoolean("remove_advancements_from_pause", false).comment(new String[]{"When enabled, the advancements button will be removed from the pause menu."});
    public static final SNBTConfig PAUSE_SCREEN = CONFIG.addGroup("pause_screen");
    public static final BooleanValue ENABLE_SUPPORT_PROVIDER = (BooleanValue)PAUSE_SCREEN.addBoolean("enable_support_provider", true).comment(new String[]{"When enabled, the support provider will be enabled in the top left of the pause screen. This is used for modpacks to provide support information."});
    public static final StringValue SUPPORT_GITHUB_URL = (StringValue)PAUSE_SCREEN.addString("support_github_url", "https://go.ftb.team/support-modpack").comment(new String[]{"The URL to open when the support provider's GitHub icon is clicked. If this is empty, the GitHub icon will not be shown."});
    public static final StringValue SUPPORT_DISCORD_URL = (StringValue)PAUSE_SCREEN.addString("support_discord_url", "https://go.ftb.team/discord").comment(new String[]{"The URL to open when the support provider's Discord icon is clicked. If this is empty, the Discord icon will not be shown."});

    public static void load() {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)PackCompanionExpectPlatform.getConfigDirectory(), (String)"ftbpc");
    }
}

