/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.client.screen.pause.providers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.packcompanion.PackCompanion;
import dev.ftb.packcompanion.api.client.pause.AdditionalPauseProvider;
import dev.ftb.packcompanion.api.client.pause.AdditionalPauseTarget;
import dev.ftb.packcompanion.api.client.pause.ScreenHolder;
import dev.ftb.packcompanion.api.client.pause.ScreenWidgetCollection;
import dev.ftb.packcompanion.config.PCClientConfig;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SupportPauseProvider
implements AdditionalPauseProvider {
    private static final ResourceLocation DISCORD_ICON = PackCompanion.id("textures/gui/discord.png");
    private static final ResourceLocation GITHUB_ICON = PackCompanion.id("textures/gui/github.png");

    @Override
    @Nullable
    public ScreenWidgetCollection init(AdditionalPauseTarget target, ScreenHolder screen, int x, int y) {
        if (!((Boolean)PCClientConfig.ENABLE_SUPPORT_PROVIDER.get()).booleanValue()) {
            return null;
        }
        ScreenWidgetCollection screenWidgetCollection = ScreenWidgetCollection.create();
        String githubUrl = (String)PCClientConfig.SUPPORT_GITHUB_URL.get();
        String discordUrl = (String)PCClientConfig.SUPPORT_DISCORD_URL.get();
        int xOffset = x;
        if (!discordUrl.isEmpty()) {
            screenWidgetCollection.addRenderableWidget(new IconButton(xOffset, y, 20, 20, DISCORD_ICON, "ftbpackcompanion.tooltip.support_discord", button -> Util.getPlatform().openUri(discordUrl)));
            xOffset += 24;
        }
        if (!githubUrl.isEmpty()) {
            screenWidgetCollection.addRenderableWidget(new IconButton(xOffset, y, 20, 20, GITHUB_ICON, "ftbpackcompanion.tooltip.support_github", button -> Util.getPlatform().openUri(githubUrl)));
        }
        return screenWidgetCollection;
    }

    public static class IconButton
    extends Button {
        private final ResourceLocation icon;
        private int textureSheetWidth = 16;
        private int textureSheetHeight = 16;
        private int uvx = 0;
        private int uvy = 0;
        private int textureWidth = 16;
        private int textureHeight = 16;
        private int hoverUVYOffset = 0;
        private boolean hasBackground = true;

        public IconButton(int x, int y, int width, int height, ResourceLocation icon, String langKey, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.empty(), onPress, c -> Component.translatable((String)langKey));
            this.icon = icon;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)langKey)));
        }

        public IconButton(int x, int y, int width, int height, ResourceLocation icon, String langKey, Button.OnPress onPress, int uvx, int uvy, int textureSheetWidth, int textureSheetHeight, int textureWidth, int textureHeight, int hoverUVYOffset, boolean hasBackground) {
            super(x, y, width, height, (Component)Component.empty(), onPress, c -> Component.translatable((String)langKey));
            this.icon = icon;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)langKey)));
            this.uvx = uvx;
            this.uvy = uvy;
            this.textureSheetWidth = textureSheetWidth;
            this.textureSheetHeight = textureSheetHeight;
            this.hasBackground = hasBackground;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.hoverUVYOffset = hoverUVYOffset;
        }

        public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            super.renderWidget(guiGraphics, i, j, f);
            PoseStack poseStack = guiGraphics.pose();
            if (this.hasBackground) {
                poseStack.pushPose();
                poseStack.translate((float)(this.getX() + 3), (float)(this.getY() + 3), 0.0f);
                poseStack.scale(0.85f, 0.85f, 0.0f);
                guiGraphics.blit(this.icon, 0, 0, (float)this.uvx, (float)this.uvy, this.textureWidth, this.textureHeight, this.textureSheetWidth, this.textureSheetHeight);
                poseStack.popPose();
            } else {
                int hoverOffset = this.isHovered() ? this.hoverUVYOffset : 0;
                guiGraphics.blit(this.icon, this.getX(), this.getY(), (float)this.uvx, (float)(this.uvy + hoverOffset), this.textureWidth, this.textureHeight, this.textureSheetWidth, this.textureSheetHeight);
            }
        }
    }
}

