/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.client.screen.pause;

import com.mojang.realmsclient.RealmsMainScreen;
import dev.architectury.platform.Platform;
import dev.ftb.packcompanion.PackCompanionExpectPlatform;
import dev.ftb.packcompanion.api.client.PackCompanionClientAPI;
import dev.ftb.packcompanion.api.client.pause.AdditionalPauseProvider;
import dev.ftb.packcompanion.api.client.pause.AdditionalPauseTarget;
import dev.ftb.packcompanion.api.client.pause.ScreenHolder;
import dev.ftb.packcompanion.api.client.pause.ScreenWidgetCollection;
import dev.ftb.packcompanion.config.PCClientConfig;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CustomPauseScreen
extends Screen {
    public static boolean DISABLE_CUSTOM_PAUSE = false;
    private static final Component RETURN_TO_GAME = Component.translatable((String)"menu.returnToGame");
    private static final Component ADVANCEMENTS = Component.translatable((String)"gui.advancements");
    private static final Component STATS = Component.translatable((String)"gui.stats");
    private static final Component OPTIONS = Component.translatable((String)"menu.options");
    private static final Component SHARE_TO_LAN = Component.translatable((String)"menu.shareToLan");
    private static final Component PLAYER_REPORTING = Component.translatable((String)"menu.playerReporting");
    private static final Component RETURN_TO_MENU = Component.translatable((String)"menu.returnToMenu");
    private static final Component GAME = Component.translatable((String)"menu.game");
    private static final Component SAVING_LEVEL = Component.translatable((String)"menu.savingLevel");
    Minecraft minecraft = Minecraft.getInstance();
    ScreenHolder holder = ScreenHolder.of(this);
    @Nullable
    private Button disconnectButton;

    public CustomPauseScreen() {
        super(GAME);
    }

    protected void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        rowHelper.addChild((LayoutElement)Button.builder((Component)RETURN_TO_GAME, button -> {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
        }).width(204).build(), 2, gridLayout.newCellSettings().paddingTop(50));
        Boolean noAdvancements = (Boolean)PCClientConfig.REMOVE_ADVANCEMENTS_FROM_PAUSE.get();
        if (!noAdvancements.booleanValue()) {
            rowHelper.addChild((LayoutElement)this.openScreenButton(ADVANCEMENTS, () -> new AdvancementsScreen(this.minecraft.player.connection.getAdvancements(), (Screen)this)));
        }
        rowHelper.addChild((LayoutElement)this.openScreenButton(STATS, () -> new StatsScreen((Screen)this, this.minecraft.player.getStats())));
        if (PackCompanionExpectPlatform.hasModlistScreen()) {
            rowHelper.addChild((LayoutElement)this.openScreenButton((Component)Component.translatable((String)"ftbpackcompanion.pause.mods", (Object[])new Object[]{Platform.getMods().size()}), () -> PackCompanionExpectPlatform.getModListScreen().apply(this), noAdvancements != false ? 98 : 204), noAdvancements != false ? 1 : 2);
        }
        rowHelper.addChild((LayoutElement)this.openScreenButton(OPTIONS, () -> new OptionsScreen((Screen)this, this.minecraft.options)));
        if (this.minecraft.hasSingleplayerServer() && !this.minecraft.getSingleplayerServer().isPublished()) {
            rowHelper.addChild((LayoutElement)this.openScreenButton(SHARE_TO_LAN, () -> new ShareToLanScreen((Screen)this)));
        } else {
            rowHelper.addChild((LayoutElement)this.openScreenButton(PLAYER_REPORTING, () -> new SocialInteractionsScreen((Screen)this)));
        }
        Component component = this.minecraft.isLocalServer() ? RETURN_TO_MENU : CommonComponents.GUI_DISCONNECT;
        this.disconnectButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)component, button -> {
            button.active = false;
            this.minecraft.getReportingContext().draftReportHandled(this.minecraft, (Screen)this, this::onDisconnect, true);
        }).width(204).build(), 2);
        gridLayout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridLayout, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.25f);
        gridLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.initAdditionalPauseProviders();
    }

    private void initAdditionalPauseProviders() {
        PackCompanionClientAPI.get().getAdditionalPauseProviders().forEach((target, providers) -> {
            int[] location = this.calculatePosition((AdditionalPauseTarget)((Object)target));
            for (AdditionalPauseProvider provider : providers) {
                ScreenWidgetCollection widgetCollection = provider.init((AdditionalPauseTarget)((Object)target), this.holder, location[0], location[1]);
                if (widgetCollection == null) continue;
                widgetCollection.commitToScreen(this);
            }
        });
    }

    private Button openScreenButton(Component component, Supplier<Screen> supplier) {
        return this.openScreenButton(component, supplier, 98);
    }

    private Button openScreenButton(Component component, Supplier<Screen> supplier, int width) {
        return Button.builder((Component)component, button -> this.minecraft.setScreen((Screen)supplier.get())).width(width).build();
    }

    private void onDisconnect() {
        boolean bl = this.minecraft.isLocalServer();
        ServerData serverData = this.minecraft.getCurrentServer();
        this.minecraft.level.disconnect();
        if (bl) {
            this.minecraft.disconnect((Screen)new GenericMessageScreen(SAVING_LEVEL));
        } else {
            this.minecraft.disconnect();
        }
        TitleScreen titleScreen = new TitleScreen();
        if (bl) {
            this.minecraft.setScreen((Screen)titleScreen);
        } else if (serverData != null && serverData.isRealm()) {
            this.minecraft.setScreen((Screen)new RealmsMainScreen((Screen)titleScreen));
        } else {
            this.minecraft.setScreen((Screen)new JoinMultiplayerScreen((Screen)titleScreen));
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        return super.keyPressed(i, j, k);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        this.renderBackground(guiGraphics, mouseX, mouseY, f);
        super.render(guiGraphics, mouseX, mouseY, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        PackCompanionClientAPI.get().getAdditionalPauseProviders().forEach((target, providers) -> {
            int[] position = this.calculatePosition((AdditionalPauseTarget)((Object)target));
            for (AdditionalPauseProvider provider : providers) {
                provider.render((AdditionalPauseTarget)((Object)target), this.holder, guiGraphics, position[0], position[1], mouseX, mouseY, f);
            }
        });
    }

    private int[] calculatePosition(AdditionalPauseTarget target) {
        int[] nArray;
        switch (target) {
            default: {
                throw new MatchException(null, null);
            }
            case TOP_LEFT: {
                int[] nArray2 = new int[2];
                nArray2[0] = 4;
                nArray = nArray2;
                nArray2[1] = 4;
                break;
            }
            case TOP_RIGHT: {
                int[] nArray3 = new int[2];
                nArray3[0] = this.width - 4;
                nArray = nArray3;
                nArray3[1] = 4;
                break;
            }
            case TOP_CENTER: {
                int[] nArray4 = new int[2];
                nArray4[0] = this.width / 2;
                nArray = nArray4;
                nArray4[1] = 4;
                break;
            }
            case BOTTOM_LEFT: {
                int[] nArray5 = new int[2];
                nArray5[0] = 4;
                nArray = nArray5;
                nArray5[1] = this.height - 4;
                break;
            }
            case BOTTOM_RIGHT: {
                int[] nArray6 = new int[2];
                nArray6[0] = this.width - 4;
                nArray = nArray6;
                nArray6[1] = this.height - 4;
                break;
            }
            case BOTTOM_CENTER: {
                int[] nArray7 = new int[2];
                nArray7[0] = this.width / 2;
                nArray = nArray7;
                nArray7[1] = this.height - 4;
                break;
            }
            case MENU_LEFT: {
                int[] nArray8 = new int[2];
                nArray8[0] = this.width / 2 - 102 - 4;
                nArray = nArray8;
                nArray8[1] = this.height / 4 + 56;
                break;
            }
            case MENU_RIGHT: {
                int[] nArray9 = new int[2];
                nArray9[0] = this.width / 2 + 102 + 4;
                nArray = nArray9;
                nArray9[1] = this.height / 4 + 56;
            }
        }
        return nArray;
    }
}

