/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.block.SouliumSpawnerBlock;
import com.blakebr0.mysticalagriculture.container.SouliumSpawnerContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;

public class SouliumSpawnerTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 200;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    public static final int SPAWN_RADIUS = 3;
    private final BaseItemStackHandler inventory = SouliumSpawnerTileEntity.createInventoryHandler(slot -> this.onInventoryChanged());
    private final UpgradeItemStackHandler upgradeInventory = new UpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((SouliumSpawnerTileEntity)this).setChangedFast());
    private final SidedInventoryWrapper[] sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
    private final CachedRecipe<CraftingInput, ISouliumSpawnerRecipe> recipe = new CachedRecipe((RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get());
    private MachineUpgradeTier tier;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;
    private double spin;
    private double oSpin;
    private DisplayEntity[] displayEntities;

    public SouliumSpawnerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.SOULIUM_SPAWNER.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.put("Energy", this.energy.serializeNBT(lookup));
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public void onLoad() {
        super.onLoad();
        this.reloadActiveRecipe();
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider lookup) {
        super.onDataPacket(connection, packet, lookup);
        this.reloadActiveRecipe();
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookup) {
        super.handleUpdateTag(tag, lookup);
        this.reloadActiveRecipe();
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.mysticalagriculture.soulium_spawner").build();
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return SouliumSpawnerContainer.create(id, playerInventory, this.inventory, this.upgradeInventory, this.getBlockPos());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public IItemHandler getSidedInventory(Direction direction) {
        if (direction == null) {
            direction = Direction.NORTH;
        }
        return switch (direction) {
            case Direction.UP -> this.sidedInventoryWrappers[0];
            case Direction.DOWN -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SouliumSpawnerTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(1, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean isDisabled = level.hasNeighborSignal(tile.getBlockPos());
        boolean wasRunning = tile.isRunning;
        tile.isRunning = false;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage() && !isDisabled) {
            ItemStack input = tile.inventory.getStackInSlot(0);
            if (!input.isEmpty()) {
                ISouliumSpawnerRecipe recipe = tile.getActiveRecipe();
                if (recipe != null && input.getCount() >= recipe.getCount(0)) {
                    tile.isRunning = true;
                    ++tile.progress;
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                    if (tile.progress >= tile.getOperationTime() && tile.attemptSpawn(recipe)) {
                        tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)input, (int)recipe.getCount(0), (boolean)false));
                        tile.progress = 0;
                        tile.sendSpawnParticles();
                    }
                    tile.setChangedFast();
                }
            } else {
                tile.isRunning = false;
                if (tile.progress > 0) {
                    tile.progress = 0;
                    tile.setChangedFast();
                }
            }
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SouliumSpawnerBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, SouliumSpawnerTileEntity tile) {
        Boolean isRunning = (Boolean)state.getValue((Property)SouliumSpawnerBlock.RUNNING);
        double spinSpeed = isRunning != false ? 200.0 : 400.0;
        tile.oSpin = tile.spin;
        tile.spin = (tile.spin + 1000.0 / spinSpeed) % 360.0;
        if (isRunning.booleanValue()) {
            tile.sendRunningParticles();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return SouliumSpawnerTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)2, (OnContentsChangedFunction)onContentsChanged, builder -> builder.addSlotLimit(0, 512));
    }

    public ISouliumSpawnerRecipe getActiveRecipe() {
        return (ISouliumSpawnerRecipe)this.recipe.get();
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 200;
        }
        return (int)(200.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 20;
        }
        return (int)(20.0 * this.tier.getFuelUsageMultiplier());
    }

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }

    public DisplayEntity getDisplayEntity() {
        if (this.displayEntities == null) {
            return null;
        }
        int index = Math.toIntExact(System.currentTimeMillis() / 2000L % (long)this.displayEntities.length);
        return this.displayEntities[index];
    }

    private CraftingInput toCraftingInput() {
        return this.inventory.toShapelessCraftingInput(0, 1);
    }

    private boolean attemptSpawn(ISouliumSpawnerRecipe recipe) {
        if (this.level == null) {
            return false;
        }
        Entity entity = recipe.getRandomEntityType(this.level.random).map(e -> ((EntityType)e.data()).create(this.level)).orElse(null);
        if (entity == null) {
            return false;
        }
        long entities = this.level.getEntitiesOfClass(entity.getClass(), AABB.ofSize((Vec3)this.getBlockPos().getCenter(), (double)6.0, (double)6.0, (double)6.0)).stream().filter(Entity::isAlive).count();
        if (entities >= 32L) {
            return false;
        }
        List<BlockPos> positions = BlockPos.betweenClosedStream((BlockPos)this.getBlockPos().offset(-3, 0, -3), (BlockPos)this.getBlockPos().offset(3, 0, 3)).map(BlockPos::immutable).toList();
        BlockPos pos = positions.get(this.level.random.nextInt(positions.size()));
        entity.setUUID(UUID.randomUUID());
        entity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(this.getBlockPos()), MobSpawnType.MOB_SUMMONED, null);
        }
        int attempts = 20;
        while (attempts-- > 0 && !this.canEntitySpawn(entity)) {
            pos = positions.get(this.level.random.nextInt(positions.size()));
            entity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
        }
        if (attempts <= 0) {
            return false;
        }
        this.level.addFreshEntity(entity);
        return true;
    }

    private boolean canEntitySpawn(Entity entity) {
        return this.level != null && this.level.isUnobstructed(entity) && !this.level.containsAnyLiquid(entity.getBoundingBox());
    }

    private void onInventoryChanged() {
        this.reloadActiveRecipe();
        this.setChangedFast();
    }

    private void reloadActiveRecipe() {
        if (this.level == null) {
            return;
        }
        ISouliumSpawnerRecipe recipe = (ISouliumSpawnerRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
        if (recipe != null) {
            List entities = recipe.getEntityTypes().unwrap();
            Integer totalWeight = entities.stream().map(e -> e.getWeight().asInt()).reduce(0, Integer::sum);
            this.displayEntities = (DisplayEntity[])entities.stream().map(e -> new DisplayEntity(((EntityType)e.data()).create(this.level), (double)e.getWeight().asInt() / (double)totalWeight.intValue() * 100.0)).toArray(DisplayEntity[]::new);
        } else {
            this.displayEntities = null;
        }
    }

    private void sendRunningParticles() {
        if (this.level == null) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        double x = (double)pos.getX() + Math.random() / 2.0 + 0.25;
        double y = (double)pos.getY() + Math.random() / 2.0 + 0.25;
        double z = (double)pos.getZ() + Math.random() / 2.0 + 0.25;
        this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
    }

    private void sendSpawnParticles() {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.getLevel();
        BlockPos pos = this.getBlockPos();
        for (int i = 0; i < 20; ++i) {
            double x = (double)pos.getX() + Math.random();
            double y = (double)pos.getY() + Math.random();
            double z = (double)pos.getZ() + Math.random();
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return RecipeIngredientCache.INSTANCE.isValidSouliumSpawnerInput(stack);
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        return false;
    }

    public record DisplayEntity(Entity entity, double chance) {
    }
}

