/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.CropHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.block.HarvesterBlock;
import com.blakebr0.mysticalagriculture.container.HarvesterContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HarvesterTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 40;
    public static final int SCAN_FUEL_USAGE = 10;
    public static final int FUEL_CAPACITY = 80000;
    public static final int BASE_RANGE = 1;
    private final BaseItemStackHandler inventory;
    private final UpgradeItemStackHandler upgradeInventory;
    private final DynamicEnergyStorage energy;
    private List<BlockPos> positions;
    private BlockPos lastPosition = BlockPos.ZERO;
    private MachineUpgradeTier tier;
    private Direction direction;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public HarvesterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.HARVESTER.get(), pos, state);
        this.inventory = HarvesterTileEntity.createInventoryHandler(slot -> this.setChangedFast());
        this.upgradeInventory = new UpgradeItemStackHandler();
        this.energy = new DynamicEnergyStorage(80000, () -> ((HarvesterTileEntity)this).setChangedFast());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.mysticalagriculture.harvester").build();
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return HarvesterContainer.create(i, inventory, this.inventory, this.upgradeInventory, this.getBlockPos());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.lastPosition = BlockPos.of((long)tag.getLong("LastPosition"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.putLong("LastPosition", this.lastPosition.asLong());
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HarvesterTileEntity tile) {
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(0);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        MachineUpgradeTier tier = tile.getMachineTier();
        Direction direction = (Direction)state.getValue((Property)HarvesterBlock.FACING);
        if (tier != tile.tier || direction != tile.direction) {
            int range = tier != null ? 1 + tier.getAddedRange() : 1;
            BlockPos center = pos.relative(direction, range + 1);
            tile.tier = tier;
            tile.direction = direction;
            tile.positions = HarvesterTileEntity.getWorkingArea(center, range, direction);
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean isDisabled = level.hasNeighborSignal(tile.getBlockPos());
        int operationTime = tile.getOperationTime();
        if (tile.progress > operationTime && !isDisabled) {
            BlockPos nextPos = tile.findNextPosition();
            BlockState cropState = level.getBlockState(nextPos);
            Block block = cropState.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)block);
                if (seed != null && crop.isMaxAge(cropState)) {
                    List drops = Block.getDrops((BlockState)cropState, (ServerLevel)((ServerLevel)level), (BlockPos)nextPos, (BlockEntity)tile);
                    for (ItemStack drop : drops) {
                        Item item = drop.getItem();
                        if (drop.isEmpty() || item != seed) continue;
                        drop.shrink(1);
                        break;
                    }
                    for (ItemStack drop : drops) {
                        if (drop.isEmpty()) continue;
                        tile.addItemToInventory(drop, level, nextPos);
                    }
                    level.setBlockAndUpdate(nextPos, crop.getStateForAge(0));
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                } else {
                    tile.energy.extractEnergy(10, false);
                }
            }
            tile.progress = 0;
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        if (!isDisabled && tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ++tile.progress;
            tile.isRunning = true;
            tile.setChangedFast();
        } else {
            tile.isRunning = false;
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HarvesterBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return HarvesterTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)16, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setCanInsert((slot, stack) -> slot == 0 && stack.getBurnTime(null) > 0);
            builder.setCanExtract(slot -> slot > 0);
        });
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 100;
        }
        return (int)(100.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 40;
        }
        return (int)(40.0 * this.tier.getFuelUsageMultiplier());
    }

    private static List<BlockPos> getWorkingArea(BlockPos center, int range, Direction direction) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        switch (direction) {
            case NORTH: {
                for (int x = -range; x < range + 1; ++x) {
                    for (int z = -range; z < range + 1; ++z) {
                        positions.add(new BlockPos(center.getX() + x, center.getY(), center.getZ() + z));
                    }
                }
                break;
            }
            case SOUTH: {
                for (int x = range; x > -range - 1; --x) {
                    for (int z = range; z > -range - 1; --z) {
                        positions.add(new BlockPos(center.getX() + x, center.getY(), center.getZ() + z));
                    }
                }
                break;
            }
            case EAST: {
                for (int z = -range; z < range + 1; ++z) {
                    for (int x = range; x > -range - 1; --x) {
                        positions.add(new BlockPos(center.getX() + x, center.getY(), center.getZ() + z));
                    }
                }
                break;
            }
            case WEST: {
                for (int z = range; z > -range - 1; --z) {
                    for (int x = -range; x < range + 1; ++x) {
                        positions.add(new BlockPos(center.getX() + x, center.getY(), center.getZ() + z));
                    }
                }
                break;
            }
        }
        return positions;
    }

    private BlockPos findNextPosition() {
        if (this.lastPosition == null) {
            this.lastPosition = this.positions.get(0);
            return this.lastPosition;
        }
        int index = this.positions.indexOf(this.lastPosition);
        if (index == -1 || index >= this.positions.size() - 1) {
            this.lastPosition = this.positions.get(0);
            return this.lastPosition;
        }
        this.lastPosition = this.positions.get(index + 1);
        return this.lastPosition;
    }

    private void addItemToInventory(ItemStack stack, Level level, BlockPos pos) {
        int remaining = stack.getCount();
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.isEmpty()) {
                this.inventory.setStackInSlot(i, stack.copy());
                return;
            }
            if (StackHelper.areStacksEqual((ItemStack)stackInSlot, (ItemStack)stack)) {
                int insertSize = Math.min(remaining, stackInSlot.getMaxStackSize() - stackInSlot.getCount());
                this.inventory.setStackInSlot(i, StackHelper.grow((ItemStack)stackInSlot, (int)insertSize));
                remaining -= insertSize;
            }
            if (remaining != 0) continue;
            return;
        }
        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)StackHelper.withSize((ItemStack)stack, (int)remaining, (boolean)false));
    }
}

