/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock;
import com.blakebr0.mysticalagriculture.container.EssenceFurnaceContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class EssenceFurnaceTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 200;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory = EssenceFurnaceTileEntity.createInventoryHandler(slot -> this.setChangedFast());
    private final UpgradeItemStackHandler upgradeInventory = new UpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((EssenceFurnaceTileEntity)this).setChangedFast());
    private final SidedInventoryWrapper[] sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
    private final CachedRecipe<SingleRecipeInput, SmeltingRecipe> recipe = new CachedRecipe(RecipeType.SMELTING);
    private MachineUpgradeTier tier;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public EssenceFurnaceTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FURNACE.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.put("Energy", this.energy.serializeNBT(lookup));
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.mysticalagriculture.furnace").build();
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return EssenceFurnaceContainer.create(id, playerInventory, this.inventory, this.upgradeInventory, this.getBlockPos());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public IItemHandler getSidedInventory(@Nullable Direction direction) {
        if (direction == null) {
            direction = Direction.NORTH;
        }
        return switch (direction) {
            case Direction.UP -> this.sidedInventoryWrappers[0];
            case Direction.DOWN -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EssenceFurnaceTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(1, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ItemStack input = tile.inventory.getStackInSlot(0);
            ItemStack output = tile.inventory.getStackInSlot(2);
            tile.isRunning = false;
            if (!input.isEmpty()) {
                ItemStack recipeOutput;
                SmeltingRecipe recipe = tile.getActiveRecipe();
                if (recipe != null && !(recipeOutput = recipe.assemble(new SingleRecipeInput(input), (HolderLookup.Provider)level.registryAccess())).isEmpty() && (output.isEmpty() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)recipeOutput))) {
                    tile.isRunning = true;
                    ++tile.progress;
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                    if (tile.progress >= tile.getOperationTime()) {
                        tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)input, (int)1, (boolean)false));
                        tile.inventory.setStackInSlot(2, StackHelper.combineStacks((ItemStack)output, (ItemStack)recipeOutput));
                        tile.progress = 0;
                    }
                    tile.setChangedFast();
                }
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.setChangedFast();
            }
        } else {
            tile.isRunning = false;
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)EssenceFurnaceBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public SmeltingRecipe getActiveRecipe() {
        return (SmeltingRecipe)this.recipe.checkAndGet((RecipeInput)new SingleRecipeInput(this.inventory.getStackInSlot(0)), this.level);
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        int operationTime;
        SmeltingRecipe recipe = (SmeltingRecipe)this.recipe.get();
        int n = operationTime = recipe != null ? recipe.getCookingTime() : 200;
        if (this.tier == null) {
            return operationTime;
        }
        return (int)((double)operationTime * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 20;
        }
        return (int)(20.0 * this.tier.getFuelUsageMultiplier());
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return true;
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        return false;
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return EssenceFurnaceTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)3, (OnContentsChangedFunction)onContentsChanged, builder -> {});
    }
}

