/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.container.SouliumSpawnerContainer;
import com.blakebr0.mysticalagriculture.tileentity.SouliumSpawnerTileEntity;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SouliumSpawnerScreen
extends BaseContainerScreen<SouliumSpawnerContainer> {
    private static final ResourceLocation BACKGROUND = MysticalAgriculture.resource("textures/gui/soulium_spawner.png");
    private SouliumSpawnerTileEntity tile;

    public SouliumSpawnerScreen(SouliumSpawnerContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title, BACKGROUND, 176, 194);
    }

    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        gfx.drawString(this.font, title, this.imageWidth / 2 - this.font.width(title) / 2, 6, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (this.tile != null) {
            MachineUpgradeTier tier = this.tile.getMachineTier();
            DynamicEnergyStorage energy = this.tile.getEnergy();
            energy.resetMaxEnergyStorage();
            if (tier != null) {
                energy.setMaxEnergyStorage((int)((double)this.tile.getEnergy().getMaxEnergyStored() * tier.getFuelCapacityMultiplier()));
            }
        }
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.getFuelItemValue() > 0) {
            int i = this.getBurnLeftScaled(13);
            gfx.blit(BACKGROUND, x + 31, y + 52 - i, 176, 12 - i, 14, i + 1);
        }
        if (this.getProgress() > 0) {
            int i2 = this.getProgressScaled(24);
            gfx.blit(BACKGROUND, x + 98, y + 51, 176, 14, i2 + 1, 16);
        }
        this.renderEntityPreview(gfx);
        if (SouliumSpawnerScreen.isHoveringSlot(x + 134, y + 52, mouseX, mouseY)) {
            SouliumSpawnerScreen.renderSlotHighlight((GuiGraphics)gfx, (int)(x + 134), (int)(y + 52), (int)0);
        }
    }

    protected void renderTooltip(GuiGraphics gfx, int mouseX, int mouseY) {
        SouliumSpawnerTileEntity.DisplayEntity displayEntity;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.renderTooltip(gfx, mouseX, mouseY);
        if (this.getFuelLeft() > 0 && mouseX > x + 30 && mouseX < x + 45 && mouseY > y + 39 && mouseY < y + 53) {
            gfx.renderTooltip(this.font, (Component)Formatting.energy((Object)this.getFuelLeft()), mouseX, mouseY);
        }
        if (this.tile != null && (displayEntity = this.tile.getDisplayEntity()) != null && SouliumSpawnerScreen.isHoveringSlot(x + 134, y + 52, mouseX, mouseY)) {
            Entity entity = displayEntity.entity();
            double chance = displayEntity.chance();
            MutableComponent text = Component.empty().append(entity.getDisplayName()).append(" (%.2f%%)".formatted(chance));
            gfx.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }

    private SouliumSpawnerTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((SouliumSpawnerContainer)this.getMenu()).getBlockPos())) instanceof SouliumSpawnerTileEntity) {
            SouliumSpawnerTileEntity spawner = (SouliumSpawnerTileEntity)tile;
            return spawner;
        }
        return null;
    }

    public int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    public int getOperationTime() {
        if (this.tile == null) {
            return 0;
        }
        MachineUpgradeTier tier = this.tile.getMachineTier();
        if (tier != null) {
            return (int)((double)this.tile.getOperationTime() * tier.getOperationTimeMultiplier());
        }
        return this.tile.getOperationTime();
    }

    public int getFuelLeft() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelLeft();
    }

    public int getFuelItemValue() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getFuelItemValue();
    }

    public int getProgressScaled(int pixels) {
        int i = this.getProgress();
        int j = this.getOperationTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.getFuelLeft();
        int j = this.getFuelItemValue();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }

    private void renderEntityPreview(GuiGraphics gfx) {
        if (this.tile == null) {
            return;
        }
        SouliumSpawnerTileEntity.DisplayEntity displayEntity = this.tile.getDisplayEntity();
        if (displayEntity == null) {
            return;
        }
        Entity entity = displayEntity.entity();
        float scale = 16.0f;
        float bbMax = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if ((double)bbMax > 1.0) {
            scale /= bbMax;
        }
        PoseStack matrix = gfx.pose();
        matrix.pushPose();
        matrix.translate((float)(this.leftPos + 142), (float)(this.topPos + 68), 32.0f);
        matrix.mulPose(Axis.YP.rotationDegrees(135.0f));
        matrix.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrix.scale(scale, scale, scale);
        MultiBufferSource.BufferSource buffer = gfx.bufferSource();
        Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (MultiBufferSource)buffer, 255);
        matrix.popPose();
    }

    private static boolean isHoveringSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX > x - 1 && mouseX < x + 16 && mouseY > y - 1 && mouseY < y + 16;
    }
}

