/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureDataComponentTypes;
import com.blakebr0.mysticalagriculture.api.components.SoulJarComponent;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MobSoulUtils {
    public static DataComponentMap makeComponentMap(MobSoulType type) {
        return MobSoulUtils.makeComponentMap(type, type.getSoulRequirement());
    }

    public static DataComponentMap makeComponentMap(MobSoulType type, double souls) {
        SoulJarComponent component = new SoulJarComponent(type.getId(), Math.min(souls, type.getSoulRequirement()));
        return DataComponentMap.builder().set(MysticalAgricultureDataComponentTypes.SOUL_JAR, (Object)component).build();
    }

    public static ItemStack getSoulJar(MobSoulType type, double souls, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(MysticalAgricultureDataComponentTypes.SOUL_JAR, (Object)new SoulJarComponent(type.getId(), souls));
        return stack;
    }

    public static ItemStack getFilledSoulJar(MobSoulType type, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(MysticalAgricultureDataComponentTypes.SOUL_JAR, (Object)new SoulJarComponent(type.getId(), type.getSoulRequirement()));
        return stack;
    }

    public static MobSoulType getType(ItemStack stack) {
        SoulJarComponent component = (SoulJarComponent)stack.get(MysticalAgricultureDataComponentTypes.SOUL_JAR);
        if (component != null) {
            return MysticalAgricultureAPI.getMobSoulTypeRegistry().getMobSoulTypeById(component.type());
        }
        return null;
    }

    public static double getSouls(ItemStack stack) {
        SoulJarComponent component = (SoulJarComponent)stack.get(MysticalAgricultureDataComponentTypes.SOUL_JAR);
        if (component != null) {
            return component.souls();
        }
        return 0.0;
    }

    public static boolean canAddTypeToJar(ItemStack stack, MobSoulType type) {
        MobSoulType containedType = MobSoulUtils.getType(stack);
        return containedType == null || containedType == type;
    }

    public static boolean isJarFull(ItemStack stack) {
        MobSoulType type = MobSoulUtils.getType(stack);
        return type != null && MobSoulUtils.getSouls(stack) >= type.getSoulRequirement();
    }

    public static double addSoulsToJar(ItemStack stack, MobSoulType type, double amount) {
        SoulJarComponent component;
        MobSoulType containedType = MobSoulUtils.getType(stack);
        if (containedType != null && containedType != type) {
            return amount;
        }
        double requirement = type.getSoulRequirement();
        if (containedType == null) {
            stack.set(MysticalAgricultureDataComponentTypes.SOUL_JAR, (Object)new SoulJarComponent(type.getId(), amount));
            return Math.max(0.0, amount - requirement);
        }
        double souls = MobSoulUtils.getSouls(stack);
        if (souls < requirement && (component = (SoulJarComponent)stack.get(MysticalAgricultureDataComponentTypes.SOUL_JAR)) != null) {
            double newSouls = Math.min(requirement, souls + amount);
            stack.set(MysticalAgricultureDataComponentTypes.SOUL_JAR, (Object)new SoulJarComponent(type.getId(), newSouls));
            return Math.max(0.0, amount - (newSouls - souls));
        }
        return amount;
    }
}

