/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.multiblock.data;

import com.folumo.mekanism_lasers.common.block_entity.EnergyStorageCellBlockEntity;
import com.folumo.mekanism_lasers.common.block_entity.EnergyStoragePortBlockEntity;
import com.folumo.mekanism_lasers.common.multiblock.container.energyStorageMultiblockContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.CableUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class energyStorageMultiblockData
extends MultiblockData {
    private final List<MultiblockData.EnergyOutputTarget> energyOutputTargets = new ArrayList<MultiblockData.EnergyOutputTarget>();
    @NotNull
    private final energyStorageMultiblockContainer energyContainer = new energyStorageMultiblockContainer(this);

    public energyStorageMultiblockData(BlockEntity tile) {
        super(tile);
        this.energyContainers.add(this.energyContainer);
    }

    public boolean tick(Level world) {
        boolean ret = super.tick(world);
        this.energyContainer.tick();
        if (!this.energyOutputTargets.isEmpty() && !this.energyContainer.isEmpty()) {
            CableUtils.emit((Collection)this.getActiveOutputs(this.energyOutputTargets), (IEnergyContainer)this.energyContainer, (long)Long.MAX_VALUE);
        }
        return ret;
    }

    public void addEnergy(long energy) {
        this.energyContainer.insert(energy, Action.EXECUTE, AutomationType.INTERNAL);
    }

    public void addCell(EnergyStorageCellBlockEntity cell) {
        this.energyContainer.addCell(cell.getBlockPos(), cell);
    }

    protected void updateEjectors(Level world) {
        this.energyOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            EnergyStoragePortBlockEntity tile = (EnergyStoragePortBlockEntity)WorldUtils.getTileEntity(EnergyStoragePortBlockEntity.class, (BlockGetter)world, (BlockPos)valve.location);
            if (tile == null) continue;
            tile.addEnergyTargetCapability(this.energyOutputTargets, valve.side);
        }
    }
}

