/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block_entity;

import com.folumo.mekanism_lasers.common.registry.BlockRegistry;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserStopperBlockEntity
extends TileEntityMekanism
implements ILaserReceptor {
    @Nullable
    private BlockState currentBlockState;

    public LaserStopperBlockEntity(BlockPos pos, @Nullable BlockState state) {
        super(BlockRegistry.LASER_STOPPER, pos, state);
        this.currentBlockState = state;
    }

    @NotNull
    public Component getName() {
        return Component.literal((String)"Laser Stopper");
    }

    public void receiveLaserEnergy(long energy) {
    }

    public boolean canLasersDig() {
        return false;
    }

    public void changeTexture(BlockState state) {
        this.currentBlockState = state;
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public BlockState getCurrentBlockState() {
        return this.currentBlockState;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.currentBlockState = BlockState.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound("currentBlockState"))).result().orElse(null);
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.put("currentBlockState", BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.currentBlockState).result().orElseGet(CompoundTag::new));
    }
}

