/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block_entity;

import com.folumo.mekanism_lasers.common.tier.LaserTier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class LaserBlockEntity
extends TileEntityLaserReceptor {
    private final LaserTier tier;

    public LaserBlockEntity(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.tier = (LaserTier)Attribute.getTier((IBlockProvider)blockProvider, LaserTier.class);
        if (this.tier == LaserTier.CREATIVE) {
            this.energyContainer.insert(Long.MAX_VALUE, Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((LaserBlockEntity)this).getDirection());
        for (int slotX = 0; slotX < 5; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                OutputInventorySlot slot = OutputInventorySlot.at((IContentsListener)listener, (int)(8 + slotX * 18), (int)(16 + slotY * 18));
                builder.addSlot((IInventorySlot)slot);
                slot.setSlotType(ContainerSlotType.NORMAL);
            }
        }
        return builder.build();
    }

    public void receiveLaserEnergy(long energy) {
    }

    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create((Predicate)BasicEnergyContainer.notExternal, (Predicate)BasicEnergyContainer.alwaysTrue, (TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
    }

    protected long toFire() {
        return this.tier.getEnergyUsage();
    }

    @NotNull
    public Component getName() {
        return Component.literal((String)"Laser");
    }

    protected boolean onUpdateServer() {
        boolean ret = super.onUpdateServer();
        if (this.tier == LaserTier.CREATIVE) {
            this.energyContainer.insert(Long.MAX_VALUE, Action.EXECUTE, AutomationType.INTERNAL);
        }
        return ret;
    }
}

