/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block_entity;

import com.folumo.mekanism_lasers.common.item.RemoteControlItem;
import com.folumo.mekanism_lasers.common.registry.BlockRegistry;
import java.util.UUID;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class InterfaceBlockEntity
extends TileEntityMekanism {
    private static boolean lastRedstoneLevel;

    public InterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(BlockRegistry.INTERFACE_BLOCK, pos, state);
        lastRedstoneLevel = false;
    }

    @NotNull
    public Component getName() {
        return Component.literal((String)"Interface Block");
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((InterfaceBlockEntity)this).getDirection());
        InputInventorySlot slot = InputInventorySlot.at((IContentsListener)listener, (int)8, (int)16);
        builder.addSlot((IInventorySlot)slot);
        slot.setSlotType(ContainerSlotType.NORMAL);
        return builder.build();
    }

    protected boolean hasNeighborSignal(Level level, BlockPos blockPos) {
        return level.hasSignal(blockPos.north(), Direction.NORTH) || level.hasSignal(blockPos.east(), Direction.EAST) || level.hasSignal(blockPos.south(), Direction.SOUTH) || level.hasSignal(blockPos.west(), Direction.WEST) || level.hasSignal(blockPos.above(), Direction.UP) || level.hasSignal(blockPos.below(), Direction.DOWN);
    }

    protected boolean onUpdateServer() {
        boolean ret = super.onUpdateServer();
        Level level = this.getLevel();
        if (level == null) {
            return ret;
        }
        boolean thisRedstoneLevel = this.hasNeighborSignal(level, this.getBlockPos());
        if (thisRedstoneLevel != lastRedstoneLevel) {
            lastRedstoneLevel = thisRedstoneLevel;
            if (thisRedstoneLevel) {
                Item item;
                IInventorySlot slot = this.getInventorySlot(0, null);
                if (slot == null) {
                    return ret;
                }
                ItemStack stack = slot.getStack();
                if (!stack.isEmpty() && (item = stack.getItem()) instanceof RemoteControlItem) {
                    ServerPlayer player;
                    RemoteControlItem item2 = (RemoteControlItem)item;
                    ServerLevel serverLevel = (ServerLevel)this.getLevel();
                    MinecraftServer server = serverLevel.getServer();
                    UUID ownerUUID = this.getOwnerUUID();
                    if (ownerUUID != null && (player = server.getPlayerList().getPlayer(ownerUUID)) != null) {
                        item2.switchLaserMode(stack, this.getLevel(), (Player)player);
                    }
                }
            }
        }
        return ret;
    }
}

