/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.data;

import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.items.Items;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

class Language
extends LanguageProvider {
    Language(PackOutput output) {
        super(output, "magic_doorknob", "en_us");
    }

    protected void addTranslations() {
        this.add(Blocks.MAGIC_DOOR.get(), "Magic Door");
        this.add(Blocks.MAGIC_DOORWAY.get(), "Magic Doorway");
        this.addDoorknob("diamond");
        this.addDoorknob("gold", "Golden");
        this.addDoorknob("iron");
        this.addDoorknob("netherite");
        this.addDoorknob("stone");
        this.addDoorknob("wood", "Wooden");
    }

    private void addDoorknob(String typeName) {
        this.addDoorknob(typeName, StringUtils.capitalize((String)typeName));
    }

    private void addDoorknob(String typeName, String materialName) {
        MagicDoorknobItem doorknob = (MagicDoorknobItem)((Object)Items.DOORKNOBS.get(typeName).get());
        this.add(doorknob, String.format("%s Magic Doorknob", materialName));
    }

    @Nonnull
    public String getName() {
        return String.format("%s %s", "magic_doorknob", super.getName());
    }
}

