/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.data;

import com.tomboshoven.minecraft.magicdoorknob.data.BlockStates;
import com.tomboshoven.minecraft.magicdoorknob.data.ItemModels;
import com.tomboshoven.minecraft.magicdoorknob.data.Language;
import com.tomboshoven.minecraft.magicdoorknob.data.Recipes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class DataGenerators {
    private DataGenerators() {
    }

    public static void register(IEventBus eventBus) {
        eventBus.addListener(DataGenerators::gatherData);
    }

    private static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean includeServer = event.includeServer();
        boolean includeClient = event.includeClient();
        generator.addProvider(includeServer, output -> new BlockStates(output, existingFileHelper));
        generator.addProvider(includeServer, Language::new);
        generator.addProvider(includeServer, output -> new Recipes(output, lookupProvider));
        generator.addProvider(includeClient, output -> new ItemModels(output, existingFileHelper));
    }
}

