/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks;

import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayPartBaseBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class MagicDoorwayPartBaseBlock
extends Block
implements EntityBlock {
    MagicDoorwayPartBaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorwayPartBaseBlockEntity) {
            BlockState baseBlock = ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState();
            return baseBlock.getBlock().getSoundType(baseBlock, world, pos, null);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorwayPartBaseBlockEntity) {
            return ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState().getLightEmission(world, pos);
        }
        return super.getLightEmission(state, world, pos);
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorwayPartBaseBlockEntity) {
            return ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState().getLightBlock(worldIn, pos);
        }
        return super.getLightBlock(state, worldIn, pos);
    }

    public float getFriction(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorwayPartBaseBlockEntity) {
            return ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState().getFriction(world, pos, entity);
        }
        return super.getFriction(state, world, pos, entity);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorwayPartBaseBlockEntity) {
            return ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState().getDestroyProgress(player, worldIn, pos);
        }
        return super.getDestroyProgress(state, player, worldIn, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorwayPartBaseBlockEntity) {
            return ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState().canHarvestBlock(world, pos, player);
        }
        return super.canHarvestBlock(state, world, pos, player);
    }

    public static enum EnumPartType implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

