/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks;

import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayPartBaseBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MagicDoorwayBlock
extends MagicDoorwayPartBaseBlock {
    public static final EnumProperty<MagicDoorwayPartBaseBlock.EnumPartType> PART = EnumProperty.create((String)"part", MagicDoorwayPartBaseBlock.EnumPartType.class);
    public static final BooleanProperty OPEN_CROSS_TOP_BOTTOM = BooleanProperty.create((String)"open_cross_top_bottom");
    public static final BooleanProperty OPEN_NORTH_SOUTH = BooleanProperty.create((String)"open_north_south");
    public static final BooleanProperty OPEN_EAST_WEST = BooleanProperty.create((String)"open_east_west");
    private static final VoxelShape BOUNDING_BOX_PILLAR_NW = MagicDoorwayBlock.box((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_PILLAR_NE = MagicDoorwayBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape BOUNDING_BOX_PILLAR_SW = MagicDoorwayBlock.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0);
    private static final VoxelShape BOUNDING_BOX_PILLAR_SE = MagicDoorwayBlock.box((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WALL_S = MagicDoorwayBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape BOUNDING_BOX_WALL_N = MagicDoorwayBlock.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WALL_E = MagicDoorwayBlock.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WALL_W = MagicDoorwayBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_TOP = MagicDoorwayBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    MagicDoorwayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM))).setValue((Property)OPEN_EAST_WEST, (Comparable)Boolean.TRUE)).setValue((Property)OPEN_NORTH_SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)OPEN_CROSS_TOP_BOTTOM, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean openNorthSouth = (Boolean)state.getValue((Property)OPEN_NORTH_SOUTH);
        boolean openEastWest = (Boolean)state.getValue((Property)OPEN_EAST_WEST);
        boolean isTop = state.getValue(PART) == MagicDoorwayPartBaseBlock.EnumPartType.TOP;
        VoxelShape result = Shapes.empty();
        if (openNorthSouth && openEastWest) {
            result = Shapes.or((VoxelShape)result, (VoxelShape[])new VoxelShape[]{BOUNDING_BOX_PILLAR_NE, BOUNDING_BOX_PILLAR_NW, BOUNDING_BOX_PILLAR_SE, BOUNDING_BOX_PILLAR_SW});
        } else {
            if (!openNorthSouth) {
                result = Shapes.or((VoxelShape)result, (VoxelShape[])new VoxelShape[]{BOUNDING_BOX_WALL_N, BOUNDING_BOX_WALL_S});
            }
            if (!openEastWest) {
                result = Shapes.or((VoxelShape)result, (VoxelShape[])new VoxelShape[]{BOUNDING_BOX_WALL_E, BOUNDING_BOX_WALL_W});
            }
        }
        if (isTop) {
            result = Shapes.or((VoxelShape)result, (VoxelShape)BOUNDING_BOX_TOP);
        }
        return result;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (newState.isAir() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof MagicDoorwayBlockEntity) {
            worldIn.setBlockAndUpdate(pos, ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState());
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, OPEN_NORTH_SOUTH, OPEN_EAST_WEST, OPEN_CROSS_TOP_BOTTOM});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MagicDoorwayBlockEntity(pos, state);
    }
}

