/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjeiextras.advancedae;

import appeng.core.AppEng;
import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftbjeiextras.modspecific.GlodiumHelpers;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberRecipeCategory
implements IRecipeCategory<ReactionChamberRecipe> {
    public static final RecipeType<ReactionChamberRecipe> TYPE = RecipeType.create((String)"advanced_ae", (String)"reaction", ReactionChamberRecipe.class);
    private static final ResourceLocation BG_ASSET = AppEng.makeId((String)"textures/guis/reaction_chamber.png");
    private static final ResourceLocation BOLT_ASSET = AdvancedAE.makeId((String)"textures/guis/emi.png");
    private IDrawableStatic background;
    private IDrawable icon;
    private IDrawableAnimated charge;
    private IDrawableStatic boltIcon;
    private final IGuiHelper guiHelper;

    public ReactionChamberRecipeCategory(IJeiHelpers helpers) {
        this.guiHelper = helpers.getGuiHelper();
        this.background = this.guiHelper.createDrawable(BG_ASSET, 5, 15, 168, 75);
        this.icon = this.guiHelper.createDrawableItemStack(new ItemStack((ItemLike)AAEBlocks.REACTION_CHAMBER));
        this.charge = this.guiHelper.createAnimatedDrawable(this.guiHelper.createDrawable(BG_ASSET, 176, 0, 6, 18), 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.boltIcon = this.guiHelper.createDrawable(BOLT_ASSET, 0, 0, 16, 16);
    }

    public RecipeType<ReactionChamberRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)AAEText.EmiReactionChamber.getTranslationKey());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ReactionChamberRecipe recipe, IFocusGroup focuses) {
        int x = 37;
        for (IngredientStack.Item in : recipe.getInputs()) {
            if (in.isEmpty()) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, x, 9).addIngredients(GlodiumHelpers.of(in));
            x += 18;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 28).addItemStack(recipe.getResultItem());
    }

    public void draw(ReactionChamberRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.charge.draw(guiGraphics, 135, 27);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)AAEText.ReactionChamberEnergy.text(new Object[]{recipe.getEnergy() / 1000}), 35, 68, 0x5E5E5E, false);
        this.guiHelper.drawableBuilder(BOLT_ASSET, 0, 0, 16, 16).setTextureSize(32, 32).build().draw(guiGraphics, 22, 65);
        int fluidX = 4;
        int fluidY = 6;
        int fluidWidth = 16;
        int fluidMaxHeight = 58;
        int maxAmount = 16000;
        if (recipe.getFluid() != null) {
            FluidStack[] stacks;
            IngredientStack.Fluid fluid = recipe.getFluid();
            for (FluidStack stack : stacks = ((FluidIngredient)fluid.getIngredient()).getStacks()) {
                if (stack.isEmpty()) continue;
                IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidType)stack.getFluidType());
                ResourceLocation FLUID_TEXTURE = props.getStillTexture().withPrefix("textures/").withSuffix(".png");
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                int color = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor();
                RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)0.9f);
                int fluidAmount = stack.getAmount();
                int fluidHeight = (int)((float)fluidAmount / (float)maxAmount * (float)fluidMaxHeight * 2.0f);
                int renderY = fluidY + fluidMaxHeight - fluidHeight;
                this.guiHelper.drawableBuilder(FLUID_TEXTURE, 0, 0, fluidWidth, fluidHeight).setTextureSize(16, 16).build().draw(guiGraphics, fluidX, renderY);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                if (!(mouseX >= (double)fluidX) || !(mouseX <= (double)(fluidX + fluidWidth)) || !(mouseY >= (double)fluidY) || !(mouseY <= (double)(fluidY + fluidMaxHeight))) break;
                List<MutableComponent> textComponents = List.of(Component.literal((String)"Fluid: ").append((Component)Component.translatable((String)stack.getFluidType().getDescriptionId())), Component.literal((String)("Amount: " + stack.getAmount())));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, textComponents, Optional.empty(), (int)mouseX, (int)mouseY);
                break;
            }
        }
    }
}

