/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.block;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.apothic_spawners.block.LyingLevel;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class ApothSpawnerTile
extends SpawnerBlockEntity {
    protected final Map<SpawnerStat<?>, Object> customStats = new IdentityHashMap();

    public ApothSpawnerTile(BlockPos pos, BlockState state) {
        super(pos, state);
        this.spawner = new SpawnerLogicExt();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag stats = new CompoundTag();
        this.customStats.forEach((stat, value) -> {
            try {
                Tag encoded = (Tag)stat.getValueCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, value).getOrThrow();
                stats.put(stat.getId().toString(), encoded);
            }
            catch (Exception ex) {
                ApothicSpawners.LOGGER.error("Failed saving spawner stat " + String.valueOf(stat.getId()), (Throwable)ex);
            }
        });
        tag.put("stats", (Tag)stats);
        super.saveAdditional(tag, registries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag stats = tag.getCompound("stats");
        for (String key : stats.getAllKeys()) {
            SpawnerStat stat = (SpawnerStat)SpawnerStats.REGISTRY.get(ResourceLocation.tryParse((String)key));
            if (stat == null) continue;
            Tag value = stats.get(key);
            try {
                Object realValue = ((Pair)stat.getValueCodec().decode((DynamicOps)NbtOps.INSTANCE, (Object)value).getOrThrow()).getFirst();
                this.customStats.put(stat, realValue);
            }
            catch (Exception ex) {
                ApothicSpawners.LOGGER.error("Failed loading spawner stat " + key, (Throwable)ex);
            }
        }
        super.loadAdditional(tag, registries);
    }

    public Map<SpawnerStat<?>, Object> getStatsMap() {
        return this.customStats;
    }

    public class SpawnerLogicExt
    extends BaseSpawner {
        public void setEntityId(EntityType<?> type, @Nullable Level level, RandomSource rand, BlockPos pos) {
            this.nextSpawnData = new SpawnData();
            super.setEntityId(type, level, rand, pos);
            this.spawnPotentials = SimpleWeightedRandomList.single((Object)this.nextSpawnData);
            if (level != null) {
                this.delay(level, pos);
            }
        }

        public void broadcastEvent(Level level, BlockPos pos, int id) {
            level.blockEvent(pos, Blocks.SPAWNER, id, 0);
        }

        public void setNextSpawnData(Level level, BlockPos pos, SpawnData nextSpawnData) {
            super.setNextSpawnData(level, pos, nextSpawnData);
            if (level != null) {
                BlockState state = level.getBlockState(pos);
                level.sendBlockUpdated(pos, state, state, 4);
            }
        }

        public Either<BlockEntity, Entity> getOwner() {
            return Either.left((Object)((Object)ApothSpawnerTile.this));
        }

        protected boolean isActivated(Level level, BlockPos pos) {
            boolean hasPlayer = this.getStatValue(SpawnerStats.IGNORE_PLAYERS) != false || this.isNearPlayer(level, pos);
            return hasPlayer && (this.getStatValue(SpawnerStats.REDSTONE_CONTROL) == false || ApothSpawnerTile.this.level.hasNeighborSignal(pos));
        }

        private void delay(Level pLevel, BlockPos pPos) {
            this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + pLevel.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
            this.spawnPotentials.getRandom(pLevel.random).ifPresent(potential -> this.setNextSpawnData(pLevel, pPos, (SpawnData)potential.data()));
            this.broadcastEvent(pLevel, pPos, 1);
        }

        public void clientTick(Level pLevel, BlockPos pPos) {
            if (!this.isActivated(pLevel, pPos)) {
                this.oSpin = this.spin;
            } else {
                double d0 = (double)pPos.getX() + pLevel.random.nextDouble();
                double d1 = (double)pPos.getY() + pLevel.random.nextDouble();
                double d2 = (double)pPos.getZ() + pLevel.random.nextDouble();
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.oSpin = this.spin;
                this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            }
        }

        public void serverTick(ServerLevel level, BlockPos pPos) {
            if (this.isActivated((Level)level, pPos)) {
                if (this.spawnDelay == -1) {
                    this.delay((Level)level, pPos);
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                } else {
                    boolean flag = false;
                    RandomSource rand = level.getRandom();
                    SpawnData spawnData = this.getOrCreateNextSpawnData((Level)level, rand, pPos);
                    for (int i = 0; i < this.spawnCount; ++i) {
                        Entity entity;
                        double z;
                        CompoundTag tag = spawnData.getEntityToSpawn();
                        EntityType entityType = EntityType.by((CompoundTag)tag).orElse(null);
                        if (entityType == null) {
                            this.delay((Level)level, pPos);
                            return;
                        }
                        ListTag posList = tag.getList("Pos", 6);
                        int size = posList.size();
                        double x = size >= 1 ? posList.getDouble(0) : (double)pPos.getX() + (rand.nextDouble() - rand.nextDouble()) * (double)this.spawnRange + 0.5;
                        double y = size >= 2 ? posList.getDouble(1) : (double)(pPos.getY() + rand.nextInt(3) - 1);
                        double d = z = size >= 3 ? posList.getDouble(2) : (double)pPos.getZ() + (rand.nextDouble() - rand.nextDouble()) * (double)this.spawnRange + 0.5;
                        if (!level.noCollision(entityType.getSpawnAABB(x, y, z))) continue;
                        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
                        LyingLevel liar = new LyingLevel(level);
                        boolean useLiar = false;
                        if (!this.getStatValue(SpawnerStats.IGNORE_CONDITIONS).booleanValue()) {
                            if (this.getStatValue(SpawnerStats.IGNORE_LIGHT).booleanValue()) {
                                boolean pass = false;
                                for (int light = 0; light < 16; ++light) {
                                    liar.setFakeLightLevel(light);
                                    if (!this.checkSpawnRules(spawnData, entityType, liar, blockpos)) continue;
                                    pass = true;
                                    break;
                                }
                                if (!pass) continue;
                                useLiar = true;
                            } else if (!this.checkSpawnRules(spawnData, entityType, (ServerLevelAccessor)level, blockpos)) continue;
                        }
                        if ((entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, freshEntity -> {
                            freshEntity.moveTo(x, y, z, freshEntity.getYRot(), freshEntity.getXRot());
                            return freshEntity;
                        })) == null) {
                            this.delay((Level)level, pPos);
                            return;
                        }
                        int nearby = level.getEntitiesOfClass(entity.getClass(), new AABB((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (double)(pPos.getX() + 1), (double)(pPos.getY() + 1), (double)(pPos.getZ() + 1)).inflate((double)this.spawnRange)).size();
                        if (nearby >= this.maxNearbyEntities) {
                            this.delay((Level)level, pPos);
                            return;
                        }
                        entity.getSelfAndPassengers().forEach(selfOrPassenger -> {
                            Mob mob;
                            if (this.getStatValue(SpawnerStats.NO_AI).booleanValue() && selfOrPassenger instanceof Mob) {
                                mob = (Mob)selfOrPassenger;
                                mob.setNoAi(true);
                                mob.getPersistentData().putBoolean("apotheosis:movable", true);
                            }
                            if (this.getStatValue(SpawnerStats.YOUTHFUL).booleanValue() && selfOrPassenger instanceof Mob) {
                                mob = (Mob)selfOrPassenger;
                                mob.setBaby(true);
                            }
                            if (this.getStatValue(SpawnerStats.SILENT).booleanValue()) {
                                selfOrPassenger.setSilent(true);
                            }
                            if (this.getStatValue(SpawnerStats.INITIAL_HEALTH).floatValue() != 1.0f && selfOrPassenger instanceof LivingEntity) {
                                LivingEntity living = (LivingEntity)selfOrPassenger;
                                living.setHealth(living.getHealth() * this.getStatValue(SpawnerStats.INITIAL_HEALTH).floatValue());
                            }
                            if (this.getStatValue(SpawnerStats.BURNING).booleanValue() && !selfOrPassenger.fireImmune()) {
                                selfOrPassenger.setRemainingFireTicks(Integer.MAX_VALUE);
                            }
                            if (this.getStatValue(SpawnerStats.ECHOING) > 0) {
                                selfOrPassenger.getPersistentData().putInt(SpawnerStats.ECHOING.getId().toString(), this.getStatValue(SpawnerStats.ECHOING).intValue());
                            }
                        });
                        entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), rand.nextFloat() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            Mob mob = (Mob)entity;
                            if (!this.checkSpawnPositionSpawner(mob, useLiar ? liar : level, MobSpawnType.SPAWNER, spawnData, this)) continue;
                            boolean shouldFinalize = spawnData.getEntityToSpawn().size() == 1 && spawnData.getEntityToSpawn().contains("id", 8);
                            EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)(useLiar ? liar : level), (DifficultyInstance)level.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)shouldFinalize);
                            spawnData.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
                        }
                        if (!level.tryAddFreshEntityWithPassengers(entity)) {
                            this.delay((Level)level, pPos);
                            return;
                        }
                        level.levelEvent(2004, pPos, 0);
                        if (entity instanceof Mob) {
                            ((Mob)entity).spawnAnim();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.delay((Level)level, pPos);
                    }
                }
            }
        }

        public boolean checkSpawnPositionSpawner(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, SpawnData spawnData, BaseSpawner spawner) {
            MobSpawnEvent.PositionCheck event = new MobSpawnEvent.PositionCheck(mob, level, spawnType, spawner);
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == MobSpawnEvent.PositionCheck.Result.DEFAULT) {
                return mob.checkSpawnObstruction((LevelReader)level) && (this.getStatValue(SpawnerStats.IGNORE_CONDITIONS) != false || spawnData.getCustomSpawnRules().isPresent() || mob.checkSpawnRules((LevelAccessor)level, MobSpawnType.SPAWNER));
            }
            return event.getResult() == MobSpawnEvent.PositionCheck.Result.SUCCEED;
        }

        private boolean checkSpawnRules(SpawnData spawnData, EntityType<?> entityType, ServerLevelAccessor pServerLevel, BlockPos blockpos) {
            if (spawnData.getCustomSpawnRules().isPresent()) {
                if (!entityType.getCategory().isFriendly() && pServerLevel.getDifficulty() == Difficulty.PEACEFUL) {
                    return false;
                }
                SpawnData.CustomSpawnRules customRules = (SpawnData.CustomSpawnRules)spawnData.getCustomSpawnRules().get();
                if (this.getStatValue(SpawnerStats.IGNORE_LIGHT).booleanValue()) {
                    return true;
                }
                if (!customRules.blockLightLimit().isValueInRange((Comparable)Integer.valueOf(pServerLevel.getBrightness(LightLayer.BLOCK, blockpos))) || !customRules.skyLightLimit().isValueInRange((Comparable)Integer.valueOf(pServerLevel.getBrightness(LightLayer.SKY, blockpos)))) {
                    return false;
                }
            } else if (!SpawnPlacements.checkSpawnRules(entityType, (ServerLevelAccessor)pServerLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)pServerLevel.getRandom())) {
                return false;
            }
            return true;
        }

        private <T> T getStatValue(SpawnerStat<T> stat) {
            return stat.getValue(ApothSpawnerTile.this);
        }
    }
}

