/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.block;

import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;

public class ApothSpawnerItem
extends BlockItem {
    public ApothSpawnerItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "apothic_spawners";
    }

    public Component getName(ItemStack stack) {
        CustomData data;
        if (stack.has(DataComponents.BLOCK_ENTITY_DATA) && (data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).contains("SpawnData")) {
            try {
                String name = data.copyTag().getCompound("SpawnData").getCompound("entity").getString("id");
                EntityType t = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)name));
                if (t == null || t == EntityType.PIG && !"minecraft:pig".equals(name)) {
                    return super.getName(stack);
                }
                MobCategory cat = t.getCategory();
                ChatFormatting color = switch (cat) {
                    default -> throw new MatchException(null, null);
                    case MobCategory.AMBIENT, MobCategory.CREATURE -> ChatFormatting.DARK_GREEN;
                    case MobCategory.MONSTER -> ChatFormatting.RED;
                    case MobCategory.WATER_AMBIENT, MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.WATER_CREATURE, MobCategory.AXOLOTLS -> ChatFormatting.BLUE;
                    case MobCategory.MISC -> ChatFormatting.WHITE;
                };
                return ApothicSpawners.lang("item", "spawner", Component.translatable((String)t.getDescriptionId())).withStyle(color);
            }
            catch (Exception ex) {
                super.getName(stack);
            }
        }
        return super.getName(stack);
    }
}

