/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.apothic_spawners.ASConfig;
import dev.shadowsoffire.apothic_spawners.ASObjects;
import dev.shadowsoffire.apothic_spawners.ApothicSpawners;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStats;
import dev.shadowsoffire.placebo.events.ResourceReloadEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.MobSplitEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ASEvents {
    private static final MethodHandle dropFromLootTable;

    @SubscribeEvent
    public void handleCapturing(LivingDropsEvent e) {
        Entity killer = e.getSource().getEntity();
        LivingEntity killed = e.getEntity();
        if (killer instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)killer;
            Pair level = EnchantmentHelper.getHighestLevel((ItemStack)living.getWeaponItem(), ASObjects.CAPTURING);
            if (level == null || ASConfig.bannedMobs.contains(EntityType.getKey((EntityType)killed.getType()))) {
                return;
            }
            if (killed.level().random.nextFloat() < (float)((Integer)level.getSecond()).intValue() * ASConfig.capturingDropChance) {
                SpawnEggItem eggItem = SpawnEggItem.byId((EntityType)killed.getType());
                if (eggItem == null) {
                    return;
                }
                ItemStack egg = new ItemStack((ItemLike)eggItem);
                e.getDrops().add(new ItemEntity(killed.level(), killed.getX(), killed.getY(), killed.getZ(), egg));
            }
        }
    }

    @SubscribeEvent
    public void handleEchoing(LivingDropsEvent e) throws Throwable {
        int echoes = e.getEntity().getPersistentData().getInt(SpawnerStats.ECHOING.getId().toString());
        if (echoes > 0) {
            e.getEntity().captureDrops(new ArrayList());
            for (int i = 0; i < echoes; ++i) {
                dropFromLootTable.invoke(e.getEntity(), e.getSource(), true);
            }
            e.getDrops().addAll(e.getEntity().captureDrops(null));
        }
    }

    @SubscribeEvent
    public void handleUseItem(PlayerInteractEvent.RightClickBlock e) {
        SpawnEggItem egg;
        EntityType type;
        ItemStack s;
        Item item;
        if (e.getLevel().getBlockEntity(e.getPos()) instanceof ApothSpawnerTile && (item = (s = e.getItemStack()).getItem()) instanceof SpawnEggItem && ASConfig.bannedMobs.contains(EntityType.getKey((EntityType)(type = (egg = (SpawnEggItem)item).getType(s))))) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleTooltips(ItemTooltipEvent e) {
        SpawnEggItem egg;
        EntityType type;
        ItemStack s = e.getItemStack();
        Item item = s.getItem();
        if (item instanceof SpawnEggItem && ASConfig.bannedMobs.contains(EntityType.getKey((EntityType)(type = (egg = (SpawnEggItem)item).getType(s))))) {
            e.getToolTip().add(ApothicSpawners.lang("misc", "banned", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public void tickDumbMobs(EntityTickEvent.Pre e) {
        Entity entity = e.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.level().isClientSide && mob.isNoAi() && mob.getPersistentData().getBoolean("apotheosis:movable")) {
                mob.setNoAi(false);
                mob.travel(new Vec3((double)mob.xxa, (double)mob.zza, (double)mob.yya));
                mob.setNoAi(true);
            }
        }
    }

    @SubscribeEvent
    public void dumbMobsCantTeleport(EntityTeleportEvent e) {
        if (e.getEntity().getPersistentData().getBoolean("apotheosis:movable")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void reload(ResourceReloadEvent e) {
        if (e.getSide().isServer()) {
            ASConfig.load();
        }
    }

    @SubscribeEvent
    public void sync(OnDatapackSyncEvent e) {
        if (e.getPlayer() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)e.getPlayer(), (CustomPacketPayload)new ASConfig.ConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ASConfig.ConfigPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void split(MobSplitEvent e) {
        boolean isMoveable;
        if (e.getParent().isNoAi() && (isMoveable = e.getParent().getPersistentData().getBoolean("apotheosis:movable"))) {
            e.getChildren().forEach(mob -> mob.getPersistentData().putBoolean("apotheosis:movable", true));
        }
    }

    static {
        Method m = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"dropFromLootTable", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
        try {
            m.setAccessible(true);
            dropFromLootTable = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LivingEntity#dropFromLootTable not located!");
        }
    }
}

