/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects.mixin;

import dev.foxgirl.trimeffects.Config;
import dev.foxgirl.trimeffects.TrimEffects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmorTrim.class})
public abstract class MixinArmorTrim {
    @Shadow
    @Final
    private boolean showInTooltip;

    @Inject(method={"addToTooltip(Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/function/Consumer;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="TAIL")})
    private void trimeffects$afterAppendTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type, CallbackInfo info) {
        if (this.showInTooltip) {
            MobEffect effectType;
            ArmorTrim self = (ArmorTrim)this;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            Config.Parsed config = TrimEffects.getInstance().getConfig();
            Holder pattern = self.pattern();
            Holder material = self.material();
            ResourceKey<MobEffect> effect = config.getEffects().get(TrimEffects.getKey(pattern));
            Integer strength = config.getStrengths().get(TrimEffects.getKey(material));
            if (effect != null && strength != null && strength > 0 && (effectType = (MobEffect)TrimEffects.getRegistryManager((Entity)player).registryOrThrow(Registries.MOB_EFFECT).get(effect)) != null) {
                MutableComponent text = CommonComponents.space().append(effectType.getDisplayName());
                if (strength > 1) {
                    text.append(CommonComponents.SPACE);
                    if (strength <= 10) {
                        text.append((Component)Component.translatable((String)("enchantment.level." + strength)));
                    } else {
                        text.append(strength.toString());
                    }
                }
                tooltip.accept((Component)text.withStyle(((TrimMaterial)material.value()).description().getStyle()));
            }
        }
    }
}

