/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import dev.foxgirl.trimeffects.Config;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrimEffects {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    private static TrimEffects INSTANCE;
    private Config.Parsed config;
    private final Map<UUID, Integer> absorptionStunTicks = new HashMap<UUID, Integer>();

    @NotNull
    public static TrimEffects getInstance() {
        return INSTANCE;
    }

    @NotNull
    public static TrimEffects createInstance() {
        return new TrimEffects();
    }

    private TrimEffects() {
        INSTANCE = this;
    }

    @NotNull
    public Config.Parsed getConfig() {
        return Objects.requireNonNull(this.config, "Expression 'config'");
    }

    public void initialize(@NotNull Path configDirectory) {
        this.config = Config.read(configDirectory).parse();
    }

    @NotNull
    public static RegistryAccess getRegistryManager(@NotNull Entity entity) {
        return entity.level().registryAccess();
    }

    @NotNull
    public static <T> ResourceKey<T> getKey(@NotNull Holder<T> entry) {
        return (ResourceKey)entry.unwrapKey().orElseThrow();
    }

    @Nullable
    public static ArmorTrim getTrim(@NotNull RegistryAccess manager, @NotNull ItemStack stack) {
        return (ArmorTrim)stack.get(DataComponents.TRIM);
    }

    public void handleTick(LivingEntity player) {
        RegistryAccess manager = TrimEffects.getRegistryManager((Entity)player);
        List armor = (List)player.getArmorSlots();
        Trim[] trims = new Trim[armor.size()];
        int length = trims.length;
        for (int i = 0; i < length; ++i) {
            trims[i] = Trim.from(manager, (ItemStack)armor.get(i));
        }
        for (Trim trim : trims) {
            int count;
            if (trim == null || (!this.getConfig().isEnableCombinedEffects() ? Arrays.stream(trims).anyMatch(t -> t != null && !trim.equals(t)) : Arrays.stream(trims).anyMatch(t -> t != null && !trim.equals(t) && trim.getPattern().equals(t.getPattern()))) || (count = (int)Arrays.stream(trims).filter(t -> Objects.equals(t, trim)).count()) < this.getConfig().getMinimumMatchingTrims()) continue;
            this.handleTickForTrim(player, trim);
        }
    }

    private void handleTickForTrim(LivingEntity player, Trim trim) {
        RegistryAccess manager = TrimEffects.getRegistryManager((Entity)player);
        ResourceKey<TrimPattern> pattern = TrimEffects.getKey(trim.getPattern());
        ResourceKey<TrimMaterial> material = TrimEffects.getKey(trim.getMaterial());
        ResourceKey<MobEffect> effect = this.getConfig().getEffects().get(pattern);
        Integer strength = this.getConfig().getStrengths().get(material);
        int durationMaximum = (int)((this.getConfig().getSecondsMaximum() + 0.75) * 20.0);
        int durationMinimum = (int)((this.getConfig().getSecondsMinimum() + 0.75) * 20.0);
        if (effect != null && strength != null && strength > 0) {
            Holder.Reference effectTypeEntry;
            MobEffectInstance effectInstance;
            int amplifier = strength - 1;
            Optional effectTypeEntryOptional = manager.registryOrThrow(Registries.MOB_EFFECT).getHolder(effect);
            if (effectTypeEntryOptional.isPresent() && ((effectInstance = player.getEffect((Holder)(effectTypeEntry = (Holder.Reference)effectTypeEntryOptional.get()))) == null || effectInstance.getAmplifier() < amplifier || effectInstance.endsWithin(durationMinimum))) {
                if (effectTypeEntry.is(MobEffects.ABSORPTION)) {
                    Integer stunTicks = this.absorptionStunTicks.get(player.getUUID());
                    if (stunTicks != null && stunTicks > 0) {
                        this.absorptionStunTicks.put(player.getUUID(), stunTicks - 1);
                        return;
                    }
                    if (effectInstance != null && player.getAbsorptionAmount() < player.getMaxAbsorption()) {
                        this.absorptionStunTicks.put(player.getUUID(), (int)(this.getConfig().getAbsorptionStunSeconds() * 2.0));
                        return;
                    }
                }
                if (effectTypeEntry.is(MobEffects.REGENERATION) && effectInstance != null && !effectInstance.endsWithin(50) && player.getHealth() < player.getMaxHealth()) {
                    return;
                }
                player.addEffect(new MobEffectInstance((Holder)effectTypeEntry, durationMaximum, amplifier), (Entity)player);
            }
        }
    }

    private record Trim(@NotNull ArmorTrim trim) {
        private static Trim from(@NotNull RegistryAccess manager, @NotNull ItemStack stack) {
            ArmorTrim trim = TrimEffects.getTrim(manager, stack);
            return trim == null ? null : new Trim(trim);
        }

        @NotNull
        private Holder<TrimPattern> getPattern() {
            return this.trim.pattern();
        }

        @NotNull
        private Holder<TrimMaterial> getMaterial() {
            return this.trim.material();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Trim that = (Trim)obj;
            return Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getMaterial(), that.getMaterial());
        }
    }
}

