/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.block.entity;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlockEntities;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TeleporterBlockEntity
extends BlockEntity {
    private ItemStack crystal = ItemStack.EMPTY;
    private int cooldown = 0;

    public TeleporterBlockEntity(BlockPos pos, BlockState state) {
        super(SimpleTeleportersBlockEntities.TELEPORTER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TeleporterBlockEntity teleporter) {
        if (teleporter.isCoolingDown()) {
            teleporter.incrementCooldown();
        }
    }

    public boolean hasCrystal() {
        return !this.getCrystal().isEmpty();
    }

    public boolean isInDimension(Entity entity) {
        if (this.getCrystal().isEmpty()) {
            return false;
        }
        GlobalPos globalPos = (GlobalPos)this.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        ResourceKey dimensionKey = globalPos != null ? globalPos.dimension() : Level.OVERWORLD;
        return dimensionKey.equals(entity.level().dimension());
    }

    public ItemStack getCrystal() {
        return this.crystal;
    }

    public void setCrystal(ItemStack crystal) {
        this.crystal = crystal;
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public BlockPos getTeleportPos() {
        if (!this.hasCrystal()) {
            return null;
        }
        GlobalPos globalPos = (GlobalPos)this.getCrystal().get(SimpleTeleportersComponents.GLOBAL_POS);
        return globalPos != null ? globalPos.pos() : null;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("crystal")) {
            this.setCrystal(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("crystal")));
        } else {
            this.setCrystal(ItemStack.EMPTY);
        }
        if (tag.contains("cooldown")) {
            this.setCooldown(tag.getInt("cooldown"));
        } else {
            this.setCooldown(0);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.crystal.isEmpty()) {
            tag.put("crystal", this.crystal.save(registries, (Tag)new CompoundTag()));
        }
        tag.putInt("cooldown", this.cooldown);
    }

    public boolean isCoolingDown() {
        return this.getCooldown() > 0;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void incrementCooldown() {
        this.setCooldown(this.getCooldown() - 1);
    }
}

