/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.eventslib.util;

import com.sts15.eventslib.util.EffectData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectDurationTracker {
    private static final EffectDurationTracker INSTANCE = new EffectDurationTracker();
    private final Map<UUID, Map<MobEffectInstance, EffectData>> effectDurations = new HashMap<UUID, Map<MobEffectInstance, EffectData>>();

    private EffectDurationTracker() {
    }

    public static EffectDurationTracker getInstance() {
        return INSTANCE;
    }

    public void addOrUpdateEffect(UUID entityUUID, MobEffectInstance effectInstance, int initialDuration) {
        this.effectDurations.computeIfAbsent(entityUUID, k -> new HashMap()).put(effectInstance, new EffectData(initialDuration));
    }

    public EffectData getEffectData(UUID entityUUID, MobEffectInstance effectInstance) {
        return (EffectData)((Map)this.effectDurations.getOrDefault(entityUUID, new HashMap())).get(effectInstance);
    }

    public void removeEffect(UUID entityUUID, MobEffectInstance effectInstance) {
        Map<MobEffectInstance, EffectData> entityEffects = this.effectDurations.get(entityUUID);
        if (entityEffects != null) {
            entityEffects.remove(effectInstance);
            if (entityEffects.isEmpty()) {
                this.effectDurations.remove(entityUUID);
            }
        }
    }

    public Map<UUID, Map<MobEffectInstance, EffectData>> getAllTrackedEffects() {
        return this.effectDurations;
    }

    public boolean hasEffects(UUID entityUUID) {
        return this.effectDurations.containsKey(entityUUID) && !this.effectDurations.get(entityUUID).isEmpty();
    }
}

