/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.eventslib.mixins;

import com.sts15.eventslib.effect.IMobEffectEndCallback;
import com.sts15.eventslib.util.EffectDurationTracker;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")})
    public void onEffectRemoved(MobEffectInstance pEffectInstance, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        UUID entityUUID = self.getUUID();
        if (!self.level().isClientSide) {
            Object object = pEffectInstance.getEffect().value();
            if (object instanceof IMobEffectEndCallback) {
                IMobEffectEndCallback mobEffect = (IMobEffectEndCallback)object;
                mobEffect.onEffectRemoved(self, pEffectInstance.getAmplifier());
            }
            EffectDurationTracker.getInstance().removeEffect(entityUUID, pEffectInstance);
        }
    }
}

