/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.eventslib.events;

import com.sts15.eventslib.events.MobEffectTickEvent;
import com.sts15.eventslib.util.EffectData;
import com.sts15.eventslib.util.EffectDurationTracker;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="effectslib")
public class ServerTickEventHandler {
    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        EffectDurationTracker tracker = EffectDurationTracker.getInstance();
        ServerLevel serverLevel = event.getServer().overworld();
        for (Map.Entry<UUID, Map<MobEffectInstance, EffectData>> entry : tracker.getAllTrackedEffects().entrySet()) {
            LivingEntity livingEntity;
            UUID entityUUID = entry.getKey();
            Map<MobEffectInstance, EffectData> activeEffects = entry.getValue();
            Entity entity = serverLevel.getEntity(entityUUID);
            LivingEntity entity2 = entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
            if (entity2 == null) continue;
            activeEffects.entrySet().removeIf(effectEntry -> {
                MobEffectInstance effectInstance = (MobEffectInstance)effectEntry.getKey();
                int currentDuration = effectInstance.getDuration();
                if (currentDuration <= 0) {
                    return true;
                }
                effectInstance.tick(entity2, () -> {});
                EffectData effectData = (EffectData)effectEntry.getValue();
                int initialDuration = effectData.getInitialDuration();
                float percentageLeft = (float)currentDuration / (float)initialDuration * 100.0f;
                NeoForge.EVENT_BUS.post((Event)new MobEffectTickEvent(entity2, effectInstance, percentageLeft));
                return false;
            });
        }
    }
}

