/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.registry;

import cy.jdkdigital.productivelib.common.item.UpgradeItem;
import cy.jdkdigital.productivelib.common.recipe.TripleOutputRecipe;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.CoconutSproutBlock;
import cy.jdkdigital.productivetrees.common.block.EntitySpawner;
import cy.jdkdigital.productivetrees.common.block.PollenSifter;
import cy.jdkdigital.productivetrees.common.block.PollinatedLeaves;
import cy.jdkdigital.productivetrees.common.block.ProductiveCeilingHangingSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDanglerFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDirectionalLeavesBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDrippyFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDroppyFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLeavesBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.common.block.ProductivePlankBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveRotatedPillarBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveSaplingBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveStandingSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWallHangingSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWallSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWoodBlock;
import cy.jdkdigital.productivetrees.common.block.Sawmill;
import cy.jdkdigital.productivetrees.common.block.Stripper;
import cy.jdkdigital.productivetrees.common.block.TimeTravellerDisplay;
import cy.jdkdigital.productivetrees.common.block.WoodWorker;
import cy.jdkdigital.productivetrees.common.block.entity.EntitySpawnerBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.PollenSifterBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.ProductiveHangingSignBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.ProductiveSignBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.SawmillBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.TimeTravellerDisplayBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.WoodWorkerBlockEntity;
import cy.jdkdigital.productivetrees.common.feature.EntityPlacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.FruitLeafPlacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.FruitLeafReplacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.TrunkVineDecorator;
import cy.jdkdigital.productivetrees.common.fluid.MapleSap;
import cy.jdkdigital.productivetrees.common.fluid.type.MapleSapType;
import cy.jdkdigital.productivetrees.common.item.PollenItem;
import cy.jdkdigital.productivetrees.feature.foliageplacers.TaperedFoliagePlacer;
import cy.jdkdigital.productivetrees.feature.trunkplacers.CenteredUpwardsBranchingTrunkPlacer;
import cy.jdkdigital.productivetrees.feature.trunkplacers.UnlimitedStraightTrunkPlacer;
import cy.jdkdigital.productivetrees.integrations.productivebees.CompatHandler;
import cy.jdkdigital.productivetrees.inventory.PollenSifterContainer;
import cy.jdkdigital.productivetrees.inventory.SawmillContainer;
import cy.jdkdigital.productivetrees.inventory.StripperContainer;
import cy.jdkdigital.productivetrees.inventory.WoodWorkerContainer;
import cy.jdkdigital.productivetrees.recipe.LogStrippingRecipe;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.recipe.TreeFruitingRecipe;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.util.CropConfig;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class TreeRegistrator {
    public static final Supplier<DataComponentType<ResourceLocation>> POLLEN_BLOCK_COMPONENT = ProductiveTrees.DATA_COMPONENTS.register("pollen_block", () -> DataComponentType.builder().persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC).build());
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"productivetrees"));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = ProductiveTrees.CREATIVE_MODE_TABS.register("productivetrees", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill")))).title((Component)Component.translatable((String)"itemGroup.productivetrees")).build());
    public static final DeferredHolder<Block, Block> POLLINATED_LEAVES = TreeRegistrator.registerBlock("pollinated_leaves", () -> new PollinatedLeaves(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)), false);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PollinatedLeavesBlockEntity>> POLLINATED_LEAVES_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("pollinated_leaves", () -> TreeRegistrator.createBlockEntityType(PollinatedLeavesBlockEntity::new, (Block)POLLINATED_LEAVES.get()));
    public static final DeferredHolder<Block, Block> STRIPPER = TreeRegistrator.registerBlock("stripper", () -> new Stripper(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONECUTTER).noOcclusion()), true);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<StripperBlockEntity>> STRIPPER_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("stripper", () -> TreeRegistrator.createBlockEntityType(StripperBlockEntity::new, (Block)STRIPPER.get()));
    public static final DeferredHolder<Block, Block> SAWMILL = TreeRegistrator.registerBlock("sawmill", () -> new Sawmill(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONECUTTER).noOcclusion()), true);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<SawmillBlockEntity>> SAWMILL_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("sawmill", () -> TreeRegistrator.createBlockEntityType(SawmillBlockEntity::new, (Block)SAWMILL.get()));
    public static final DeferredHolder<Block, Block> WOOD_WORKER = TreeRegistrator.registerBlock("wood_worker", () -> new WoodWorker(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONECUTTER).noOcclusion()), true);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<WoodWorkerBlockEntity>> WOOD_WORKER_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("wood_worker", () -> TreeRegistrator.createBlockEntityType(WoodWorkerBlockEntity::new, (Block)WOOD_WORKER.get()));
    public static final DeferredHolder<Block, Block> POLLEN_SIFTER = TreeRegistrator.registerBlock("pollen_sifter", () -> new PollenSifter(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONECUTTER).noOcclusion()), true);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PollenSifterBlockEntity>> POLLEN_SIFTER_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("pollen_sifter", () -> TreeRegistrator.createBlockEntityType(PollenSifterBlockEntity::new, (Block)POLLEN_SIFTER.get()));
    public static final DeferredHolder<Block, Block> ENTITY_SPAWNER = ProductiveTrees.BLOCKS.register("entity_spawner", () -> new EntitySpawner(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AIR)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<EntitySpawnerBlockEntity>> ENTITY_SPAWNER_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("entity_spawner", () -> TreeRegistrator.createBlockEntityType(EntitySpawnerBlockEntity::new, (Block)ENTITY_SPAWNER.get()));
    public static final DeferredHolder<Block, Block> TIME_TRAVELLER_DISPLAY = TreeRegistrator.registerBlock("time_traveller_display", () -> new TimeTravellerDisplay(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).noOcclusion()), true);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TimeTravellerDisplayBlockEntity>> TIME_TRAVELLER_DISPLAY_BLOCK_ENTITY = TreeRegistrator.registerBlockEntity("time_traveller_display", () -> TreeRegistrator.createBlockEntityType(TimeTravellerDisplayBlockEntity::new, (Block)TIME_TRAVELLER_DISPLAY.get()));
    public static final DeferredHolder<MenuType<?>, MenuType<StripperContainer>> STRIPPER_MENU = ProductiveTrees.CONTAINER_TYPES.register("stripper", () -> IMenuTypeExtension.create(StripperContainer::new));
    public static final DeferredHolder<MenuType<?>, MenuType<SawmillContainer>> SAWMILL_MENU = ProductiveTrees.CONTAINER_TYPES.register("sawmill", () -> IMenuTypeExtension.create(SawmillContainer::new));
    public static final DeferredHolder<MenuType<?>, MenuType<WoodWorkerContainer>> WOOD_WORKER_MENU = ProductiveTrees.CONTAINER_TYPES.register("wood_worker", () -> IMenuTypeExtension.create(WoodWorkerContainer::new));
    public static final DeferredHolder<MenuType<?>, MenuType<PollenSifterContainer>> POLLEN_SIFTER_MENU = ProductiveTrees.CONTAINER_TYPES.register("pollen_sifter", () -> IMenuTypeExtension.create(PollenSifterContainer::new));
    public static final DeferredHolder<FluidType, FluidType> MAPLE_SAP_TYPE = ProductiveTrees.FLUID_TYPES.register("maple_sap", MapleSapType::new);
    public static final DeferredHolder<Fluid, BaseFlowingFluid> MAPLE_SAP = ProductiveTrees.FLUIDS.register("maple_sap", MapleSap.Source::new);
    public static final DeferredHolder<Fluid, BaseFlowingFluid> MAPLE_SAP_FLOWING = ProductiveTrees.FLUIDS.register("flowing_maple_sap", MapleSap.Flowing::new);
    public static final DeferredHolder<Item, Item> MAPLE_SAP_BUCKET = TreeRegistrator.registerItem("maple_sap_bucket", () -> new BucketItem((Fluid)MAPLE_SAP.get(), new Item.Properties().craftRemainder(Items.BUCKET)));
    public static final DeferredHolder<Item, Item> UPGRADE_POLLEN_SIEVE = TreeRegistrator.registerItem("upgrade_pollen_sieve", () -> new UpgradeItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> POLLEN = TreeRegistrator.registerItem("pollen", () -> new PollenItem(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SAWDUST = TreeRegistrator.registerItem("sawdust");
    public static final DeferredHolder<Item, Item> FUSTIC = TreeRegistrator.registerItem("fustic");
    public static final DeferredHolder<Item, Item> HAEMATOXYLIN = TreeRegistrator.registerItem("haematoxylin");
    public static final DeferredHolder<Item, Item> DRACAENA_SAP = TreeRegistrator.registerItem("dracaena_sap");
    public static final DeferredHolder<Item, Item> RUBBER = TreeRegistrator.registerItem("rubber");
    public static final DeferredHolder<Item, Item> CURED_RUBBER = TreeRegistrator.registerItem("cured_rubber");
    public static final DeferredHolder<Item, Item> MAPLE_SYRUP = TreeRegistrator.registerItem("maple_syrup", () -> new Item(new Item.Properties().food(Foods.HONEY_BOTTLE).craftRemainder(Items.GLASS_BOTTLE)));
    public static final DeferredHolder<Item, Item> SANDALWOOD_OIL = TreeRegistrator.registerItem("sandalwood_oil");
    public static final DeferredHolder<Item, Item> DATE_PALM_JUICE = TreeRegistrator.registerItem("date_palm_juice", () -> new Item(new Item.Properties().food(Foods.HONEY_BOTTLE).craftRemainder(Items.GLASS_BOTTLE)));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> TREE_POLLINATION = ProductiveTrees.RECIPE_SERIALIZERS.register("tree_pollination", TreePollinationRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<TreePollinationRecipe>> TREE_POLLINATION_TYPE = ProductiveTrees.RECIPE_TYPES.register("tree_pollination", () -> new RecipeType<TreePollinationRecipe>(){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> TREE_FRUITING = ProductiveTrees.RECIPE_SERIALIZERS.register("tree_fruiting", TreeFruitingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<TreeFruitingRecipe>> TREE_FRUITING_TYPE = ProductiveTrees.RECIPE_TYPES.register("tree_fruiting", () -> new RecipeType<TreeFruitingRecipe>(){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> LOG_STRIPPING = ProductiveTrees.RECIPE_SERIALIZERS.register("log_stripping", () -> new TripleOutputRecipe.Serializer(LogStrippingRecipe::new));
    public static final DeferredHolder<RecipeType<?>, RecipeType<LogStrippingRecipe>> LOG_STRIPPING_TYPE = ProductiveTrees.RECIPE_TYPES.register("log_stripping", () -> new RecipeType<LogStrippingRecipe>(){});
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> SAW_MILLLING = ProductiveTrees.RECIPE_SERIALIZERS.register("sawmill", () -> new TripleOutputRecipe.Serializer(SawmillRecipe::new));
    public static final DeferredHolder<RecipeType<?>, RecipeType<SawmillRecipe>> SAW_MILLLING_TYPE = ProductiveTrees.RECIPE_TYPES.register("sawmill", () -> new RecipeType<SawmillRecipe>(){});
    public static final ResourceKey<ConfiguredFeature<?, ?>> NULL_FEATURE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"null"));
    public static final DeferredHolder<TrunkPlacerType<?>, TrunkPlacerType<CenteredUpwardsBranchingTrunkPlacer>> CENTERED_UPWARDS_TRUNK_PLACER = ProductiveTrees.TRUNK_PLACERS.register("centered_upwards_branching_trunk_placer", () -> new TrunkPlacerType(CenteredUpwardsBranchingTrunkPlacer.CODEC));
    public static final DeferredHolder<TrunkPlacerType<?>, TrunkPlacerType<UnlimitedStraightTrunkPlacer>> UNLIMITED_STRAIGHT_TRUNK_PLACER = ProductiveTrees.TRUNK_PLACERS.register("unlimited_straight_trunk_placer", () -> new TrunkPlacerType(UnlimitedStraightTrunkPlacer.CODEC));
    public static final DeferredHolder<FoliagePlacerType<?>, FoliagePlacerType<TaperedFoliagePlacer>> TAPERED_FOLIAGE_PLACER = ProductiveTrees.FOLIAGE_PLACERS.register("tapered_foliage_placer", () -> new FoliagePlacerType(TaperedFoliagePlacer.CODEC));
    public static final DeferredHolder<TreeDecoratorType<?>, TreeDecoratorType<FruitLeafReplacerDecorator>> FRUIT_LEAF_REPLACER = ProductiveTrees.TREE_DECORATORS.register("fruit_leaf_replacer", () -> new TreeDecoratorType(FruitLeafReplacerDecorator.CODEC));
    public static final DeferredHolder<TreeDecoratorType<?>, TreeDecoratorType<FruitLeafPlacerDecorator>> FRUIT_LEAF_PLACER = ProductiveTrees.TREE_DECORATORS.register("fruit_leaf_placer", () -> new TreeDecoratorType(FruitLeafPlacerDecorator.CODEC));
    public static final DeferredHolder<TreeDecoratorType<?>, TreeDecoratorType<EntityPlacerDecorator>> ENTITY_PLACER = ProductiveTrees.TREE_DECORATORS.register("entity_placer", () -> new TreeDecoratorType(EntityPlacerDecorator.CODEC));
    public static final DeferredHolder<TreeDecoratorType<?>, TreeDecoratorType<TrunkVineDecorator>> TRUNK_VINE = ProductiveTrees.TREE_DECORATORS.register("trunk_vine", () -> new TreeDecoratorType(TrunkVineDecorator.CODEC));
    static final FoodProperties BERRY_FOOD = new FoodProperties.Builder().alwaysEdible().fast().nutrition(1).saturationModifier(0.1f).build();
    static final FoodProperties SMALL_FRUIT_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
    static final FoodProperties FRUIT_FOOD = new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
    static final FoodProperties BIG_FRUIT_FOOD = new FoodProperties.Builder().nutrition(5).saturationModifier(0.3f).build();
    static final FoodProperties CITRUS_FOOD = new FoodProperties.Builder().nutrition(2).saturationModifier(0.0f).build();
    static final FoodProperties BIG_CITRUS_FOOD = new FoodProperties.Builder().nutrition(3).saturationModifier(0.0f).build();
    static final FoodProperties NUT_FOOD = new FoodProperties.Builder().alwaysEdible().fast().nutrition(1).saturationModifier(0.1f).build();
    static final FoodProperties ROASTED_NUT_FOOD = new FoodProperties.Builder().alwaysEdible().fast().nutrition(1).saturationModifier(0.3f).build();
    public static List<CropConfig> BERRIES = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("elderberry", BERRY_FOOD));
            this.add(new CropConfig("juniper_berry", BERRY_FOOD));
            this.add(new CropConfig("sloe", BERRY_FOOD));
            this.add(new CropConfig("haw", BERRY_FOOD));
            this.add(new CropConfig("asai_berry", BERRY_FOOD));
            this.add(new CropConfig("rowan", BERRY_FOOD));
        }
    };
    public static List<CropConfig> FRUITS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("apricot", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("black_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("cherry_plum", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("date", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("fig", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("kumquat", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("olive", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("osage_orange", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("plum", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("sour_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("sparkling_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("wild_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("golden_delicious_apple", FRUIT_FOOD));
            this.add(new CropConfig("granny_smith_apple", FRUIT_FOOD));
            this.add(new CropConfig("beliy_naliv_apple", FRUIT_FOOD));
            this.add(new CropConfig("avocado", FRUIT_FOOD));
            this.add(new CropConfig("banana", FRUIT_FOOD));
            this.add(new CropConfig("red_banana", FRUIT_FOOD));
            this.add(new CropConfig("sweet_crabapple", FRUIT_FOOD));
            this.add(new CropConfig("prairie_crabapple", FRUIT_FOOD));
            this.add(new CropConfig("flowering_crabapple", FRUIT_FOOD));
            this.add(new CropConfig("grapefruit", FRUIT_FOOD));
            this.add(new CropConfig("nectarine", FRUIT_FOOD));
            this.add(new CropConfig("peach", FRUIT_FOOD));
            this.add(new CropConfig("pear", FRUIT_FOOD));
            this.add(new CropConfig("persimmon", FRUIT_FOOD));
            this.add(new CropConfig("pomelo", FRUIT_FOOD));
            this.add(new CropConfig("pomegranate", FRUIT_FOOD));
            this.add(new CropConfig("sand_pear", FRUIT_FOOD));
            this.add(new CropConfig("satsuma", FRUIT_FOOD));
            this.add(new CropConfig("snake_fruit", FRUIT_FOOD));
            this.add(new CropConfig("star_fruit", FRUIT_FOOD));
            this.add(new CropConfig("tangerine", FRUIT_FOOD));
            this.add(new CropConfig("sweetsop", FRUIT_FOOD));
            this.add(new CropConfig("coconut", BIG_FRUIT_FOOD));
            this.add(new CropConfig("mango", BIG_FRUIT_FOOD));
            this.add(new CropConfig("plantain", BIG_FRUIT_FOOD));
            this.add(new CropConfig("papaya", BIG_FRUIT_FOOD));
            this.add(new CropConfig("breadfruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("copoazu", BIG_FRUIT_FOOD));
            this.add(new CropConfig("cempedak", BIG_FRUIT_FOOD));
            this.add(new CropConfig("jackfruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("hala_fruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("soursop", BIG_FRUIT_FOOD));
            this.add(new CropConfig("baobab_fruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("lime", CITRUS_FOOD));
            this.add(new CropConfig("key_lime", CITRUS_FOOD));
            this.add(new CropConfig("finger_lime", CITRUS_FOOD));
            this.add(new CropConfig("citron", CITRUS_FOOD));
            this.add(new CropConfig("lemon", CITRUS_FOOD));
            this.add(new CropConfig("orange", BIG_CITRUS_FOOD));
            this.add(new CropConfig("mandarin", BIG_CITRUS_FOOD));
            this.add(new CropConfig("buddhas_hand", BIG_CITRUS_FOOD));
        }
    };
    public static List<CropConfig> NUTS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("almond", NUT_FOOD));
            this.add(new CropConfig("beechnut", NUT_FOOD));
            this.add(new CropConfig("brazil_nut", NUT_FOOD));
            this.add(new CropConfig("butternut", NUT_FOOD));
            this.add(new CropConfig("candlenut", NUT_FOOD));
            this.add(new CropConfig("cashew", NUT_FOOD));
            this.add(new CropConfig("chestnut", NUT_FOOD));
            this.add(new CropConfig("ginkgo_nut", NUT_FOOD));
            this.add(new CropConfig("hazelnut", NUT_FOOD));
            this.add(new CropConfig("pecan", NUT_FOOD));
            this.add(new CropConfig("pistachio", NUT_FOOD));
            this.add(new CropConfig("walnut", NUT_FOOD));
        }
    };
    public static List<CropConfig> ROASTED_NUTS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("roasted_almond", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_beechnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_brazil_nut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_butternut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_candlenut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_cashew", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_chestnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_ginkgo_nut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_hazelnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_pecan", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_pistachio", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_walnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_coffee_bean", null));
        }
    };
    public static List<ResourceLocation> CRATED_CROPS = new ArrayList<ResourceLocation>();
    public static final DeferredHolder<Item, Item> COFFEE_BEAN = TreeRegistrator.registerItem("coffee_bean");
    public static final DeferredHolder<Item, Item> CAROB = TreeRegistrator.registerItem("carob");
    public static final DeferredHolder<Item, Item> ALLSPICE = TreeRegistrator.registerItem("allspice");
    public static final DeferredHolder<Item, Item> CLOVE = TreeRegistrator.registerItem("clove");
    public static final DeferredHolder<Item, Item> CINNAMON = TreeRegistrator.registerItem("cinnamon");
    public static final DeferredHolder<Item, Item> NUTMEG = TreeRegistrator.registerItem("nutmeg");
    public static final DeferredHolder<Item, Item> STAR_ANISE = TreeRegistrator.registerItem("star_anise");
    public static final DeferredHolder<Item, Item> CORK = TreeRegistrator.registerItem("cork");
    public static final DeferredHolder<Item, Item> PLANET_PEACH = TreeRegistrator.registerItem("planet_peach", Foods.GOLDEN_CARROT);
    public static final DeferredHolder<Block, Block> AMBER_PUDDLE = TreeRegistrator.registerBlock("brown_amber_puddle", () -> new SnowLayerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SNOW).noOcclusion().sound(SoundType.SLIME_BLOCK)), false);
    public static final DeferredHolder<Block, Block> COCONUT_SPROUT = TreeRegistrator.registerBlock("coconut_sprout", () -> new CoconutSproutBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).offsetType(BlockBehaviour.OffsetType.XZ).dynamicShape()), true);
    private static List<DeferredHolder<Block, Block>> SIGNS = new ArrayList<DeferredHolder<Block, Block>>();
    private static List<DeferredHolder<Block, Block>> HANGING_SIGNS = new ArrayList<DeferredHolder<Block, Block>>();
    public static Supplier<BlockEntityType<ProductiveSignBlockEntity>> SIGN_BE;
    public static Supplier<BlockEntityType<ProductiveHangingSignBlockEntity>> HANGING_SIGN_BE;

    public static void init() {
        BERRIES.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(cropConfig.name() + "_crate")));
        });
        FRUITS.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(cropConfig.name() + "_crate")));
        });
        NUTS.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(cropConfig.name() + "_crate")));
        });
        ROASTED_NUTS.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(cropConfig.name() + "_crate")));
        });
        CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"coffee_bean_crate"));
        CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"clove_crate"));
        CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"cinnamon_crate"));
        CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"nutmeg_crate"));
        CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"star_anise_crate"));
        CRATED_CROPS.add(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"red_delicious_apple_crate"));
        CRATED_CROPS.forEach(cropName -> TreeRegistrator.registerBlock(cropName.getPath(), () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL).sound(SoundType.SCAFFOLDING)), true));
    }

    public static void registerTree(TreeObject treeObject) {
        String name = treeObject.getId().getPath();
        boolean noOcclusion = TreeUtil.isTranslucentTree(name);
        ToIntFunction<BlockState> lightLevel = state -> treeObject.getDecoration().lightLevel();
        TreeGrower grower = new TreeGrower(name, 0.1f, treeObject.getMegaFeature().equals(NULL_FEATURE) ? Optional.of(treeObject.getFeature()) : Optional.empty(), Optional.empty(), Optional.of(treeObject.getFeature()), Optional.empty(), Optional.empty(), Optional.empty());
        DeferredHolder<Block, Block> sapling = TreeRegistrator.registerBlock(name + "_sapling", () -> new ProductiveSaplingBlock(grower, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING), treeObject));
        DeferredHolder<Block, Block> pottedSapling = TreeRegistrator.registerBlock(name + "_potted_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)sapling, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_OAK_SAPLING)), false);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(name + "_sapling")), pottedSapling);
        TreeRegistrator.registerBlock(name + "_leaves", () -> new ProductiveLeavesBlock(TreeRegistrator.getProperties(Blocks.OAK_LEAVES, noOcclusion, lightLevel), treeObject));
        if (treeObject.hasFruit()) {
            if (name.equals("coconut")) {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveDroppyFruitBlock(TreeRegistrator.getProperties(Blocks.OAK_LEAVES, noOcclusion, null), treeObject, (Supplier<Block>)COCONUT_SPROUT), false);
            } else if (name.equals("brown_amber")) {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveDrippyFruitBlock(TreeRegistrator.getProperties(Blocks.OAK_LEAVES, noOcclusion, null), treeObject, (Supplier<Block>)AMBER_PUDDLE), false);
            } else if (!treeObject.getFruit().style().equals("default")) {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveDanglerFruitBlock(TreeRegistrator.getProperties(Blocks.OAK_LEAVES, noOcclusion, null).offsetType(BlockBehaviour.OffsetType.XZ).dynamicShape(), treeObject), false);
            } else {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveFruitBlock(TreeRegistrator.getProperties(Blocks.OAK_LEAVES, noOcclusion, null), treeObject), false);
            }
        }
        TreeRegistrator.registerBlock(name + "_log", () -> new ProductiveLogBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.WARPED_STEM : Blocks.OAK_LOG, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_stripped_log", () -> new ProductiveRotatedPillarBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.STRIPPED_WARPED_STEM : Blocks.STRIPPED_OAK_LOG, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_wood", () -> new ProductiveWoodBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.WARPED_STEM : Blocks.OAK_WOOD, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_stripped_wood", () -> new ProductiveRotatedPillarBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.STRIPPED_WARPED_STEM : Blocks.STRIPPED_OAK_WOOD, noOcclusion, lightLevel)));
        DeferredHolder<Block, Block> plank = TreeRegistrator.registerBlock(name + "_planks", () -> new ProductivePlankBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.WARPED_PLANKS : Blocks.OAK_PLANKS, noOcclusion, lightLevel), name));
        if (!ProductiveTrees.isMinimal) {
            TreeRegistrator.registerBlock(name + "_stairs", () -> new StairBlock(((Block)plank.get()).defaultBlockState(), TreeRegistrator.getProperties(Blocks.OAK_STAIRS, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_slab", () -> new SlabBlock(TreeRegistrator.getProperties(Blocks.OAK_SLAB, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_fence", () -> new FenceBlock(TreeRegistrator.getProperties(Blocks.OAK_FENCE, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_fence_gate", () -> new FenceGateBlock(WoodType.OAK, TreeRegistrator.getProperties(Blocks.OAK_FENCE_GATE, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, TreeRegistrator.getProperties(Blocks.OAK_PRESSURE_PLATE, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_button", () -> new ButtonBlock(BlockSetType.OAK, 30, TreeRegistrator.getProperties(Blocks.OAK_BUTTON, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_door", () -> new DoorBlock(BlockSetType.OAK, TreeRegistrator.getProperties(Blocks.OAK_DOOR, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, TreeRegistrator.getProperties(Blocks.ACACIA_TRAPDOOR, noOcclusion, lightLevel)));
            TreeRegistrator.registerBlock(name + "_bookshelf", () -> new Block(TreeRegistrator.getProperties(Blocks.BOOKSHELF, noOcclusion, lightLevel)));
            WoodType woodType = WoodType.OAK;
            try {
                woodType = WoodType.register((WoodType)new WoodType("productivetrees:" + name, BlockSetType.register((BlockSetType)new BlockSetType("productivetrees:" + name))));
            }
            catch (Exception e) {
                ProductiveTrees.LOGGER.warn("Unable to register woodtype for " + name + ". Error: " + e.getMessage());
            }
            WoodType finalWoodType = woodType;
            DeferredHolder<Block, Block> signBlock = TreeRegistrator.registerBlock(name + "_sign", () -> new ProductiveStandingSignBlock(finalWoodType, TreeRegistrator.getProperties(Blocks.OAK_SIGN, noOcclusion, lightLevel)), false);
            DeferredHolder<Block, Block> wallSignBlock = TreeRegistrator.registerBlock(name + "_wall_sign", () -> new ProductiveWallSignBlock(finalWoodType, TreeRegistrator.getProperties(Blocks.OAK_WALL_SIGN, noOcclusion, lightLevel)), false);
            DeferredHolder<Block, Block> hangingSignBlock = TreeRegistrator.registerBlock(name + "_hanging_sign", () -> new ProductiveCeilingHangingSignBlock(finalWoodType, TreeRegistrator.getProperties(Blocks.OAK_HANGING_SIGN, noOcclusion, lightLevel)), false);
            DeferredHolder<Block, Block> wallHangingSignBlock = TreeRegistrator.registerBlock(name + "_wall_hanging_sign", () -> new ProductiveWallHangingSignBlock(finalWoodType, TreeRegistrator.getProperties(Blocks.OAK_WALL_HANGING_SIGN, noOcclusion, lightLevel)), false);
            TreeRegistrator.registerItem(name + "_sign", () -> new SignItem(new Item.Properties(), (Block)signBlock.get(), (Block)wallSignBlock.get()));
            TreeRegistrator.registerItem(name + "_hanging_sign", () -> new SignItem(new Item.Properties(), (Block)hangingSignBlock.get(), (Block)wallHangingSignBlock.get()));
            SIGNS.add(signBlock);
            SIGNS.add(wallSignBlock);
            HANGING_SIGNS.add(hangingSignBlock);
            HANGING_SIGNS.add(wallHangingSignBlock);
        }
        if (treeObject.getStyle().hiveStyle() != null && ModList.get().isLoaded("productivebees")) {
            CompatHandler.createHive(name, treeObject, lightLevel);
        }
        if (name.equals("monkey_puzzle")) {
            TreeRegistrator.registerBlock("monkey_puzzle_small_leaves", () -> new ProductiveDirectionalLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), treeObject));
            TreeRegistrator.registerBlock("monkey_puzzle_medium_leaves", () -> new ProductiveDirectionalLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), treeObject));
        }
    }

    public static void registerSignBlockEntities() {
        SIGN_BE = TreeRegistrator.registerBlockEntity("productivetrees_sign", () -> TreeRegistrator.createBlockEntityType(ProductiveSignBlockEntity::new, SIGNS.stream().map(DeferredHolder::get).toList().toArray(new Block[0])));
        HANGING_SIGN_BE = TreeRegistrator.registerBlockEntity("productivetrees_hanging_sign", () -> TreeRegistrator.createBlockEntityType(ProductiveHangingSignBlockEntity::new, HANGING_SIGNS.stream().map(DeferredHolder::get).toList().toArray(new Block[0])));
    }

    public static DeferredHolder<Item, Item> registerItem(String name) {
        return TreeRegistrator.registerItem(name, () -> new Item(new Item.Properties()));
    }

    public static DeferredHolder<Item, Item> registerItem(String name, FoodProperties food) {
        return TreeRegistrator.registerItem(name, () -> new Item(new Item.Properties().food(food)));
    }

    public static DeferredHolder<Item, Item> registerItem(String name, Supplier<Item> supplier) {
        return ProductiveTrees.ITEMS.register(name, supplier);
    }

    public static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> supplier, boolean hasItem) {
        DeferredHolder block = ProductiveTrees.BLOCKS.register(name, supplier);
        if (hasItem) {
            TreeRegistrator.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    private static DeferredHolder<Block, Block> registerBlock(String name, Supplier<Block> blockSupplier) {
        return TreeRegistrator.registerBlock(name, blockSupplier, true);
    }

    public static <E extends BlockEntity, T extends BlockEntityType<E>> DeferredHolder<BlockEntityType<?>, T> registerBlockEntity(String id, Supplier<T> supplier) {
        return ProductiveTrees.BLOCK_ENTITIES.register(id, supplier);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.of(factory, (Block[])blocks).build(null);
    }

    private static BlockBehaviour.Properties getProperties(Block copyFrom, boolean noOcclusion, @Nullable ToIntFunction<BlockState> lightLevel) {
        BlockBehaviour.Properties behavior = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)copyFrom);
        if (lightLevel != null) {
            behavior = behavior.lightLevel(lightLevel);
        }
        if (noOcclusion) {
            behavior = behavior.noOcclusion();
        }
        return behavior;
    }
}

