/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivetrees.datagen.BeeProvider;
import cy.jdkdigital.productivetrees.datagen.BlockTagProvider;
import cy.jdkdigital.productivetrees.datagen.DataMapProvider;
import cy.jdkdigital.productivetrees.datagen.FeatureProvider;
import cy.jdkdigital.productivetrees.datagen.ItemTagProvider;
import cy.jdkdigital.productivetrees.datagen.LanguageProvider;
import cy.jdkdigital.productivetrees.datagen.LootDataProvider;
import cy.jdkdigital.productivetrees.datagen.LootModifierProvider;
import cy.jdkdigital.productivetrees.datagen.ModelProvider;
import cy.jdkdigital.productivetrees.datagen.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="productivetrees", bus=EventBusSubscriber.Bus.MOD)
public class ProductiveTreesDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new ModelProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        gen.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new FeatureProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new BeeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new DataMapProvider(output, provider));
        BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
    }
}

