/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.common.feature.FruitLeafPlacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.FruitLeafReplacerDecorator;
import cy.jdkdigital.productivetrees.feature.trunkplacers.CenteredUpwardsBranchingTrunkPlacer;
import cy.jdkdigital.productivetrees.feature.trunkplacers.UnlimitedStraightTrunkPlacer;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class FeatureProvider
implements DataProvider {
    private final PackOutput output;
    private final JsonElement DIRT_PROVIDER = (JsonElement)BlockStateProvider.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SimpleStateProvider.simple((Block)Blocks.DIRT)).getOrThrow();
    private final Function<SimpleStateProvider, JsonElement> MEDIUM_FRUIT_DISTRIBUTION = fruitProvider -> (JsonElement)TreeDecorator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new FruitLeafReplacerDecorator(0.4f, (BlockStateProvider)fruitProvider)).getOrThrow();
    private final Map<String, Function<SimpleStateProvider, JsonElement>> fruitDecorators = new HashMap<String, Function<SimpleStateProvider, JsonElement>>(){
        {
            this.put("default", fruitProvider -> (JsonElement)TreeDecorator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new FruitLeafReplacerDecorator(0.6f, (BlockStateProvider)fruitProvider)).getOrThrow());
            this.put("almond", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
            this.put("avocado", fruitProvider -> (JsonElement)TreeDecorator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new FruitLeafReplacerDecorator(0.3f, (BlockStateProvider)fruitProvider)).getOrThrow());
            this.put("banana", FeatureProvider.this.createDanglerFruitProvider(0.4f, 4));
            this.put("grandidiers_baobab", FeatureProvider.this.createDanglerFruitProvider(0.3f, 6));
            this.put("breadfruit", FeatureProvider.this.createDanglerFruitProvider(0.2f, 5));
            this.put("cempedak", FeatureProvider.this.createDanglerFruitProvider(0.2f, 3));
            this.put("coconut", FeatureProvider.this.createDanglerFruitProvider(0.2f, 4));
            this.put("copoazu", FeatureProvider.this.createDanglerFruitProvider(0.2f, 5));
            this.put("jackfruit", FeatureProvider.this.createDanglerFruitProvider(0.2f, 4));
            this.put("pandanus", FeatureProvider.this.createDanglerFruitProvider(0.2f, 4));
            this.put("planet_peach", FeatureProvider.this.createDanglerFruitProvider(0.2f, 7));
            this.put("plantain", FeatureProvider.this.createDanglerFruitProvider(0.2f, 3));
            this.put("red_banana", FeatureProvider.this.createDanglerFruitProvider(0.2f, 3));
            this.put("beech", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
            this.put("butternut", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
            this.put("hazel", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
            this.put("pecan", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
            this.put("pistachio", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
            this.put("wallnut", FeatureProvider.this.MEDIUM_FRUIT_DISTRIBUTION);
        }
    };
    private final Map<String, JsonElement> foliagePlacers = new HashMap<String, JsonElement>(){
        {
            this.put("default", FeatureProvider.this.createFoliage(2, 3));
            this.put("alder", FeatureProvider.this.createFoliage(4, 5));
            this.put("avocado", FeatureProvider.this.createFoliage(4, 3));
            this.put("banana", FeatureProvider.this.createFoliage(3, 1));
            this.put("balsam_fir", FeatureProvider.this.createSpruceFoliage(3, 1, 7));
            this.put("bull_pine", FeatureProvider.this.createSpruceFoliage(2, 3, 10));
            this.put("red_banana", FeatureProvider.this.createFoliage(3, 1));
            this.put("plantain", FeatureProvider.this.createFoliage(3, 1));
            this.put("asai_palm", FeatureProvider.this.createFoliage(3, 2));
            this.put("date_palm", FeatureProvider.this.createFoliage(4, 2));
            this.put("elderberry", FeatureProvider.this.createFoliage(4, 4));
            this.put("juniper", FeatureProvider.this.createFoliage(2, 6));
            this.put("allspice", FeatureProvider.this.createFoliage(3, 3));
            this.put("almond", FeatureProvider.this.createFoliage(3, 3));
            this.put("apricot", FeatureProvider.this.createFoliage(3, 3));
            this.put("aquilaria", FeatureProvider.this.createFoliage(3, 3));
            this.put("ash", FeatureProvider.this.createFoliage(3, 3));
            this.put("aspen", FeatureProvider.this.createFoliage(3, 3));
            this.put("balsa", FeatureProvider.this.createFoliage(3, 3));
            this.put("beech", FeatureProvider.this.createFoliage(3, 3));
            this.put("beliy_naliv_apple", FeatureProvider.this.createFoliage(3, 3));
            this.put("blackthorn", FeatureProvider.this.createFoliage(3, 3));
            this.put("black_cherry", FeatureProvider.this.createFoliage(3, 3));
            this.put("black_locust", FeatureProvider.this.createFoliage(3, 3));
            this.put("blue_mahoe", FeatureProvider.this.createFoliage(3, 3));
            this.put("boxwood", FeatureProvider.this.createFoliage(3, 3));
            this.put("brazilwood", FeatureProvider.this.createFoliage(3, 3));
            this.put("brazil_nut", FeatureProvider.this.createFoliage(3, 3));
            this.put("breadfruit", FeatureProvider.this.createFoliage(3, 3));
            this.put("buddhas_hand", FeatureProvider.this.createFoliage(3, 3));
            this.put("butternut", FeatureProvider.this.createFoliage(3, 3));
            this.put("cacao", FeatureProvider.this.createFoliage(3, 3));
            this.put("candlenut", FeatureProvider.this.createFoliage(3, 3));
            this.put("carob", FeatureProvider.this.createFoliage(3, 3));
            this.put("cashew", FeatureProvider.this.createFoliage(3, 3));
            this.put("cave_dweller", FeatureProvider.this.createFoliage(3, 3));
            this.put("cedar", FeatureProvider.this.createFoliage(3, 3));
            this.put("cempedak", FeatureProvider.this.createFoliage(3, 3));
            this.put("ceylon_ebony", FeatureProvider.this.createFoliage(3, 3));
            this.put("cherry_plum", FeatureProvider.this.createFoliage(3, 3));
            this.put("cinnamon", FeatureProvider.this.createFoliage(3, 3));
            this.put("citron", FeatureProvider.this.createFoliage(3, 3));
            this.put("clove", FeatureProvider.this.createFoliage(3, 3));
            this.put("cocobolo", FeatureProvider.this.createFoliage(3, 3));
            this.put("coconut", FeatureProvider.this.createFoliage(3, 3));
            this.put("coffea", FeatureProvider.this.createFoliage(3, 3));
            this.put("copoazu", FeatureProvider.this.createFoliage(3, 3));
            this.put("copper_beech", FeatureProvider.this.createFoliage(3, 3));
            this.put("cork_oak", FeatureProvider.this.createFoliage(3, 3));
            this.put("cultivated_pear", FeatureProvider.this.createFoliage(3, 3));
            this.put("dogwood", FeatureProvider.this.createFoliage(6, 3));
            this.put("douglas_fir", FeatureProvider.this.createFoliage(3, 3));
            this.put("elm", FeatureProvider.this.createFoliage(6, 7));
            this.put("european_larch", FeatureProvider.this.createFoliage(3, 3));
            this.put("finger_lime", FeatureProvider.this.createFoliage(3, 3));
            this.put("flowering_crabapple", FeatureProvider.this.createFoliage(3, 3));
            this.put("foggy_blast", FeatureProvider.this.createFoliage(3, 3));
            this.put("ginkgo", FeatureProvider.this.createFoliage(3, 3));
            this.put("golden_delicious_apple", FeatureProvider.this.createFoliage(3, 3));
            this.put("grandidiers_baobab", FeatureProvider.this.createFoliage(3, 3));
            this.put("granny_smith_apple", FeatureProvider.this.createFoliage(3, 3));
            this.put("grapefruit", FeatureProvider.this.createFoliage(3, 3));
            this.put("great_sallow", FeatureProvider.this.createFoliage(3, 3));
            this.put("greenheart", FeatureProvider.this.createFoliage(3, 3));
            this.put("hawthorn", FeatureProvider.this.createFoliage(3, 3));
            this.put("hazel", FeatureProvider.this.createFoliage(3, 3));
            this.put("holly", FeatureProvider.this.createFoliage(3, 3));
            this.put("hornbeam", FeatureProvider.this.createFoliage(3, 3));
            this.put("ipe", FeatureProvider.this.createFoliage(3, 3));
            this.put("iroko", FeatureProvider.this.createFoliage(3, 3));
            this.put("jackfruit", FeatureProvider.this.createFoliage(3, 3));
            this.put("kapok", FeatureProvider.this.createFoliage(3, 3));
            this.put("key_lime", FeatureProvider.this.createFoliage(3, 3));
            this.put("kumquat", FeatureProvider.this.createFoliage(3, 3));
            this.put("lawson_cypress", FeatureProvider.this.createSpruceFoliage(3, 4, 10));
            this.put("lemon", FeatureProvider.this.createFoliage(3, 3));
            this.put("lime", FeatureProvider.this.createFoliage(3, 3));
            this.put("loblolly_pine", FeatureProvider.this.createFoliage(3, 3));
            this.put("logwood", FeatureProvider.this.createFoliage(3, 3));
            this.put("mahogany", FeatureProvider.this.createFoliage(3, 3));
            this.put("mandarin", FeatureProvider.this.createFoliage(3, 3));
            this.put("mango", FeatureProvider.this.createFoliage(3, 3));
            this.put("monkey_puzzle", FeatureProvider.this.createFoliage(3, 3));
            this.put("moonlight_magic_crepe_myrtle", FeatureProvider.this.createFoliage(3, 3));
            this.put("myrtle_ebony", FeatureProvider.this.createFoliage(3, 3));
            this.put("nectarine", FeatureProvider.this.createFoliage(3, 3));
            this.put("nutmeg", FeatureProvider.this.createFoliage(3, 3));
            this.put("old_fustic", FeatureProvider.this.createFoliage(3, 3));
            this.put("olive", FeatureProvider.this.createFoliage(3, 3));
            this.put("orange", FeatureProvider.this.createFoliage(3, 3));
            this.put("osage_orange", FeatureProvider.this.createFoliage(3, 3));
            this.put("padauk", FeatureProvider.this.createFoliage(3, 3));
            this.put("pandanus", FeatureProvider.this.createFoliage(3, 3));
            this.put("papaya", FeatureProvider.this.createFoliage(3, 3));
            this.put("peach", FeatureProvider.this.createFoliage(3, 3));
            this.put("pecan", FeatureProvider.this.createFoliage(3, 3));
            this.put("persimmon", FeatureProvider.this.createFoliage(3, 3));
            this.put("pink_ivory", FeatureProvider.this.createFoliage(3, 3));
            this.put("pistachio", FeatureProvider.this.createFoliage(3, 3));
            this.put("plum", FeatureProvider.this.createFoliage(3, 3));
            this.put("pomegranate", FeatureProvider.this.createFoliage(3, 3));
            this.put("pomelo", FeatureProvider.this.createFoliage(3, 3));
            this.put("prairie_crabapple", FeatureProvider.this.createFoliage(3, 3));
            this.put("purpleheart", FeatureProvider.this.createFoliage(3, 3));
            this.put("purple_blackthorn", FeatureProvider.this.createFoliage(3, 3));
            this.put("purple_crepe_myrtle", FeatureProvider.this.createFoliage(3, 3));
            this.put("rainbow_gum", FeatureProvider.this.createFoliage(3, 3));
            this.put("red_crepe_myrtle", FeatureProvider.this.createFoliage(3, 3));
            this.put("red_delicious_apple", FeatureProvider.this.createFoliage(3, 3));
            this.put("red_maple", FeatureProvider.this.createFoliage(3, 3));
            this.put("rippling_willow", FeatureProvider.this.createFoliage(3, 3));
            this.put("rosewood", FeatureProvider.this.createFoliage(3, 3));
            this.put("rose_gum", FeatureProvider.this.createFoliage(3, 3));
            this.put("rowan", FeatureProvider.this.createFoliage(3, 3));
            this.put("rubber_tree", FeatureProvider.this.createFoliage(3, 3));
            this.put("salak", FeatureProvider.this.createFoliage(3, 3));
            this.put("sandalwood", FeatureProvider.this.createFoliage(3, 3));
            this.put("sand_pear", FeatureProvider.this.createFoliage(3, 3));
            this.put("satsuma", FeatureProvider.this.createFoliage(3, 3));
            this.put("sequoia", FeatureProvider.this.createFoliage(3, 3));
            this.put("silver_fir", FeatureProvider.this.createFoliage(3, 3));
            this.put("silver_lime", FeatureProvider.this.createFoliage(3, 3));
            this.put("socotra_dragon", FeatureProvider.this.createFoliage(3, 3));
            this.put("soursop", FeatureProvider.this.createFoliage(3, 3));
            this.put("sour_cherry", FeatureProvider.this.createFoliage(3, 3));
            this.put("star_anise", FeatureProvider.this.createFoliage(3, 3));
            this.put("star_fruit", FeatureProvider.this.createFoliage(3, 3));
            this.put("sugar_apple", FeatureProvider.this.createFoliage(3, 3));
            this.put("sugar_maple", FeatureProvider.this.createFoliage(3, 3));
            this.put("swamp_gum", FeatureProvider.this.createFoliage(3, 3));
            this.put("sweetgum", FeatureProvider.this.createFoliage(3, 3));
            this.put("sweet_chestnut", FeatureProvider.this.createFoliage(3, 3));
            this.put("sweet_crabapple", FeatureProvider.this.createFoliage(3, 3));
            this.put("sycamore_fig", FeatureProvider.this.createFoliage(3, 3));
            this.put("tangerine", FeatureProvider.this.createFoliage(3, 3));
            this.put("teak", FeatureProvider.this.createFoliage(3, 3));
            this.put("tuscarora_crepe_myrtle", FeatureProvider.this.createFoliage(3, 3));
            this.put("blue_yonder", FeatureProvider.this.createFoliage(3, 3));
            this.put("walnut", FeatureProvider.this.createFoliage(3, 3));
            this.put("wenge", FeatureProvider.this.createFoliage(3, 3));
            this.put("western_hemlock", FeatureProvider.this.createFoliage(3, 3));
            this.put("whitebeam", FeatureProvider.this.createFoliage(3, 3));
            this.put("white_poplar", FeatureProvider.this.createFoliage(3, 3));
            this.put("white_willow", FeatureProvider.this.createFoliage(3, 3));
            this.put("wild_cherry", FeatureProvider.this.createFoliage(3, 3));
            this.put("yellow_meranti", FeatureProvider.this.createFoliage(3, 3));
            this.put("yew", FeatureProvider.this.createFoliage(3, 3));
            this.put("zebrano", FeatureProvider.this.createFoliage(3, 3));
        }
    };
    private final Map<String, JsonElement> trunkPlacers = new HashMap<String, JsonElement>(){
        {
            this.put("default", FeatureProvider.this.createStraightTrunk(10, 3, 0));
            this.put("avocado", FeatureProvider.this.createStraightTrunk(9, 10, 0));
            this.put("banana", FeatureProvider.this.createStraightTrunk(5, 6, 0));
            this.put("balsam_fir", FeatureProvider.this.createStraightTrunk(14, 6, 0));
            this.put("black_locust", FeatureProvider.this.createStraightTrunk(12, 18, 0));
            this.put("blue_mahoe", FeatureProvider.this.createStraightTrunk(15, 5, 0));
            this.put("boxwood", FeatureProvider.this.createStraightTrunk(3, 6, 0));
            this.put("brazilwood", FeatureProvider.this.createStraightTrunk(12, 4, 0));
            this.put("cashew", FeatureProvider.this.createStraightTrunk(6, 8, 0));
            this.put("cinnamon", FeatureProvider.this.createStraightTrunk(10, 5, 0));
            this.put("clove", FeatureProvider.this.createStraightTrunk(8, 4, 0));
            this.put("cocobolo", FeatureProvider.this.createStraightTrunk(20, 5, 0));
            this.put("coconut", FeatureProvider.this.createStraightTrunk(15, 10, 0));
            this.put("coffea", FeatureProvider.this.createStraightTrunk(9, 3, 0));
            this.put("red_banana", FeatureProvider.this.createStraightTrunk(5, 6, 0));
            this.put("plantain", FeatureProvider.this.createStraightTrunk(5, 6, 0));
            this.put("asai_palm", FeatureProvider.this.createStraightTrunk(9, 5, 2));
            this.put("date_palm", FeatureProvider.this.createStraightTrunk(8, 4, 2));
            this.put("copoazu", FeatureProvider.this.createStraightTrunk(8, 2, 1));
            this.put("elderberry", FeatureProvider.this.createStraightTrunk(5, 0, 0));
            this.put("juniper", FeatureProvider.this.createStraightTrunk(4, 0, 0));
            this.put("allspice", FeatureProvider.this.createStraightTrunk(4, 2, 0));
            this.put("almond", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("apricot", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("aquilaria", FeatureProvider.this.createStraightTrunk(6, 14, 0));
            this.put("ash", FeatureProvider.this.createStraightTrunk(12, 6, 0));
            this.put("beliy_naliv_apple", FeatureProvider.this.createStraightTrunk(6, 2, 0));
            this.put("blackthorn", FeatureProvider.this.createStraightTrunk(5, 1, 1));
            this.put("buddhas_hand", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("cacao", FeatureProvider.this.createStraightTrunk(6, 6, 0));
            this.put("ceylon_ebony", FeatureProvider.this.createStraightTrunk(10, 15, 0));
            this.put("cherry_plum", FeatureProvider.this.createStraightTrunk(8, 4, 0));
            this.put("citron", FeatureProvider.this.createStraightTrunk(4, 2, 0));
            this.put("cultivated_pear", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("dogwood", FeatureProvider.this.createStraightTrunk(6, 5, 0));
            this.put("finger_lime", FeatureProvider.this.createStraightTrunk(4, 3, 0));
            this.put("flowering_crabapple", FeatureProvider.this.createStraightTrunk(8, 4, 0));
            this.put("golden_delicious_apple", FeatureProvider.this.createStraightTrunk(7, 4, 0));
            this.put("granny_smith_apple", FeatureProvider.this.createStraightTrunk(7, 4, 0));
            this.put("grapefruit", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("great_sallow", FeatureProvider.this.createStraightTrunk(4, 2, 0));
            this.put("hawthorn", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("hazel", FeatureProvider.this.createStraightTrunk(3, 5, 0));
            this.put("holly", FeatureProvider.this.createStraightTrunk(8, 15, 0));
            this.put("hornbeam", FeatureProvider.this.createStraightTrunk(15, 10, 0));
            this.put("ipe", FeatureProvider.this.createStraightTrunk(8, 5, 0));
            this.put("jackfruit", FeatureProvider.this.createStraightTrunk(9, 12, 0));
            this.put("key_lime", FeatureProvider.this.createStraightTrunk(6, 2, 0));
            this.put("kumquat", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("lawson_cypress", FeatureProvider.this.createStraightTrunk(40, 20, 0));
            this.put("lemon", FeatureProvider.this.createStraightTrunk(6, 2, 0));
            this.put("lime", FeatureProvider.this.createStraightTrunk(6, 2, 0));
            this.put("loblolly_pine", FeatureProvider.this.createStraightTrunk(25, 10, 0));
            this.put("logwood", FeatureProvider.this.createStraightTrunk(5, 10, 0));
            this.put("mandarin", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("monkey_puzzle", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("moonlight_magic_crepe_myrtle", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("myrtle_ebony", FeatureProvider.this.createStraightTrunk(6, 34, 0));
            this.put("nectarine", FeatureProvider.this.createStraightTrunk(7, 2, 0));
            this.put("nutmeg", FeatureProvider.this.createStraightTrunk(5, 10, 0));
            this.put("old_fustic", FeatureProvider.this.createStraightTrunk(5, 20, 0));
            this.put("olive", FeatureProvider.this.createStraightTrunk(5, 2, 0));
            this.put("orange", FeatureProvider.this.createStraightTrunk(7, 2, 0));
            this.put("osage_orange", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("pandanus", FeatureProvider.this.createStraightTrunk(4, 10, 0));
            this.put("papaya", FeatureProvider.this.createStraightTrunk(5, 5, 0));
            this.put("peach", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("persimmon", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("pink_ivory", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("pistachio", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("plum", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("pomegranate", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("pomelo", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("prairie_crabapple", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("purple_blackthorn", FeatureProvider.this.createStraightTrunk(5, 1, 1));
            this.put("purple_crepe_myrtle", FeatureProvider.this.createStraightTrunk(9, 2, 0));
            this.put("red_crepe_myrtle", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("red_delicious_apple", FeatureProvider.this.createStraightTrunk(7, 4, 0));
            this.put("rowan", FeatureProvider.this.createStraightTrunk(5, 10, 0));
            this.put("rubber_tree", FeatureProvider.this.createStraightTrunk(38, 5, 0));
            this.put("salak", FeatureProvider.this.createStraightTrunk(1, 2, 0));
            this.put("sandalwood", FeatureProvider.this.createStraightTrunk(4, 8, 0));
            this.put("sand_pear", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("satsuma", FeatureProvider.this.createStraightTrunk(7, 2, 0));
            this.put("socotra_dragon", FeatureProvider.this.createStraightTrunk(9, 3, 0));
            this.put("soursop", FeatureProvider.this.createStraightTrunk(7, 2, 0));
            this.put("sour_cherry", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("star_anise", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("star_fruit", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("sugar_apple", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("sugar_maple", FeatureProvider.this.createStraightTrunk(10, 2, 0));
            this.put("sweet_chestnut", FeatureProvider.this.createStraightTrunk(20, 15, 0));
            this.put("sweet_crabapple", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("sycamore_fig", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("tangerine", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("tuscarora_crepe_myrtle", FeatureProvider.this.createStraightTrunk(8, 2, 0));
            this.put("whitebeam", FeatureProvider.this.createStraightTrunk(13, 7, 0));
            this.put("white_poplar", FeatureProvider.this.createStraightTrunk(15, 15, 0));
            this.put("white_willow", FeatureProvider.this.createStraightTrunk(10, 20, 0));
            this.put("wild_cherry", FeatureProvider.this.createStraightTrunk(5, 13, 0));
            this.put("yellow_meranti", FeatureProvider.this.createStraightTrunk(40, 30, 0));
            this.put("yew", FeatureProvider.this.createStraightTrunk(10, 10, 0));
        }
    };

    public FeatureProvider(PackOutput output) {
        this.output = output;
    }

    private static Block getBlock(ResourceLocation tree, String name) {
        return (Block)BuiltInRegistries.BLOCK.get(tree.withPath(p -> p + name));
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        PackOutput.PathProvider placedFeaturePath = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "worldgen/placed_feature");
        PackOutput.PathProvider configuredFeaturePath = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "worldgen/configured_feature");
        ArrayList output = new ArrayList();
        HashMap placedFeatures = Maps.newHashMap();
        HashMap configuredFeatures = Maps.newHashMap();
        TreeFinder.trees.forEach((id, treeObject) -> {
            placedFeatures.put(treeObject.getId(), this.getPlacedFeature((TreeObject)treeObject));
            if (!TreeUtil.isSpecialTree(treeObject.getId())) {
                configuredFeatures.put(treeObject.getId(), this.getConfiguredFeature((TreeObject)treeObject));
            }
        });
        placedFeatures.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)placedFeaturePath.json(rLoc))));
        configuredFeatures.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)configuredFeaturePath.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Productive Trees Feature generator";
    }

    private Supplier<JsonElement> getPlacedFeature(TreeObject treeObject) {
        return () -> {
            JsonElement placement = (JsonElement)PlacementModifier.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)TreeUtil.getBlock(treeObject.getId(), "_sapling").defaultBlockState(), (Vec3i)Vec3i.ZERO))).getOrThrow();
            JsonArray placementArray = new JsonArray();
            placementArray.add(placement);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("feature", treeObject.getId().toString());
            jsonObject.add("placement", (JsonElement)placementArray);
            return jsonObject;
        };
    }

    private Supplier<JsonElement> getConfiguredFeature(TreeObject treeObject) {
        String name = treeObject.getId().getPath();
        return () -> {
            JsonObject config = new JsonObject();
            JsonArray decoratorArray = new JsonArray();
            if (treeObject.hasFruit()) {
                BlockState state = TreeUtil.getBlock(treeObject.getId(), "_fruit").defaultBlockState();
                if (treeObject.getId().getPath().equals("banana")) {
                    state = (BlockState)state.setValue((Property)ProductiveFruitBlock.getAgeProperty(), (Comparable)Integer.valueOf(1));
                }
                decoratorArray.add(this.fruitDecorators.containsKey(name) ? this.fruitDecorators.get(name).apply(SimpleStateProvider.simple((BlockState)state)) : this.fruitDecorators.get("default").apply(SimpleStateProvider.simple((BlockState)state)));
            }
            config.add("decorators", (JsonElement)decoratorArray);
            config.add("dirt_provider", this.DIRT_PROVIDER);
            config.add("foliage_placer", this.foliagePlacers.containsKey(name) ? this.foliagePlacers.get(name) : this.foliagePlacers.get("default"));
            config.add("foliage_provider", (JsonElement)BlockStateProvider.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SimpleStateProvider.simple((Block)TreeUtil.getBlock(treeObject.getId(), "_leaves"))).getOrThrow());
            config.add("minimum_size", (JsonElement)FeatureSize.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TwoLayersFeatureSize(1, 0, 1)).getOrThrow());
            config.add("trunk_placer", this.trunkPlacers.containsKey(name) ? this.trunkPlacers.get(name) : this.trunkPlacers.get("default"));
            config.add("trunk_provider", (JsonElement)BlockStateProvider.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)SimpleStateProvider.simple((Block)TreeUtil.getBlock(treeObject.getId(), "_log"))).getOrThrow());
            config.addProperty("force_dirt", Boolean.valueOf(false));
            config.addProperty("ignore_vines", Boolean.valueOf(true));
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", "minecraft:tree");
            jsonObject.add("config", (JsonElement)config);
            return jsonObject;
        };
    }

    private JsonElement createFoliage(int radius, int height) {
        return (JsonElement)FoliagePlacer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)radius), (IntProvider)ConstantInt.of((int)0), height)).getOrThrow();
    }

    private JsonElement createSpruceFoliage(int radius, int height, int offset) {
        return (JsonElement)FoliagePlacer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new SpruceFoliagePlacer((IntProvider)ConstantInt.of((int)radius), (IntProvider)ConstantInt.of((int)offset), (IntProvider)ConstantInt.of((int)height))).getOrThrow();
    }

    private JsonElement createStraightTrunk(int height, int randA, int randB) {
        return (JsonElement)TrunkPlacer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new UnlimitedStraightTrunkPlacer(height, randA, randB)).getOrThrow();
    }

    private JsonElement createBranchingTrunk(int height, int randA, int randB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength) {
        return (JsonElement)TrunkPlacer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new CenteredUpwardsBranchingTrunkPlacer(height, randA, randB, extraBranchSteps, placeBranchPerLogProbability, extraBranchLength)).getOrThrow();
    }

    private Function<SimpleStateProvider, JsonElement> createDanglerFruitProvider(float density, int maxFruits) {
        return fruitProvider -> (JsonElement)TreeDecorator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new FruitLeafPlacerDecorator(density, maxFruits, (BlockStateProvider)fruitProvider)).getOrThrow();
    }
}

