/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.api.CableTierHolder;

public record VoltageProcessCondition(CableTier tier) implements MachineProcessCondition
{
    public static final MapCodec<VoltageProcessCondition> CODEC = RecordCodecBuilder.mapCodec(g -> g.group((App)StringRepresentable.fromValues(() -> CableTier.allTiers().stream().map(WrappedCableTier::new).toList().toArray(new WrappedCableTier[0])).fieldOf("voltage").forGetter(c -> new WrappedCableTier(c.tier()))).apply((Applicative)g, wrappedTier -> new VoltageProcessCondition(wrappedTier.tier())));
    public static final StreamCodec<RegistryFriendlyByteBuf, VoltageProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.map(CableTier::getTier, tier -> tier.name), VoltageProcessCondition::tier, VoltageProcessCondition::new);

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        MachineBlockEntity machineBlockEntity = context.getBlockEntity();
        if (machineBlockEntity instanceof CableTierHolder) {
            CableTierHolder machine = (CableTierHolder)machineBlockEntity;
            return machine.getCableTier().eu >= this.tier.eu;
        }
        return false;
    }

    public void appendDescription(List<Component> list) {
        list.add((Component)MITweaksText.RECIPE_REQUIRES_VOLTAGE.text(new Object[]{Component.translatable((String)this.tier.shortEnglishKey())}));
    }

    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }

    private record WrappedCableTier(CableTier tier) implements StringRepresentable
    {
        public String getSerializedName() {
            return this.tier.name;
        }
    }
}

