/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.blockentity;

import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.helper.transfer.LongEnergyTransferCache;

public final class FluxTransformerBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> MITweaksConfig.fluxTransformerCapacity);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(tier -> tier == MITweaksConfig.fluxTransformerCableTier);
    private final ILongEnergyStorage extractable = new ILongEnergyStorage(){

        public boolean canExtract() {
            return FluxTransformerBlockEntity.this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)FluxTransformerBlockEntity.this);
        }

        public boolean canReceive() {
            return false;
        }

        public long receive(long receive, boolean simulate) {
            return 0L;
        }

        public long extract(long extractFE, boolean simulate) {
            extractFE = Math.min(extractFE, MITweaksConfig.fluxTransformerMaxExtract);
            long extractEU = (long)((double)extractFE / MITweaksConfig.fluxTransformerConversionRate);
            long extractedEU = FluxTransformerBlockEntity.this.energy.consumeEu(extractEU, simulate ? Simulation.SIMULATE : Simulation.ACT);
            return (long)((double)extractedEU * MITweaksConfig.fluxTransformerConversionRate);
        }

        public long getAmount() {
            return (long)((double)FluxTransformerBlockEntity.this.energy.getEu() * MITweaksConfig.fluxTransformerConversionRate);
        }

        public long getCapacity() {
            return (long)((double)FluxTransformerBlockEntity.this.energy.getCapacity() * MITweaksConfig.fluxTransformerConversionRate);
        }
    };
    private final LongEnergyTransferCache transferEnergy = new LongEnergyTransferCache(() -> this.extractable);

    public FluxTransformerBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(MITweaks.id("flux_transformer"), false).build(), new OrientationComponent.Params(true, false, false));
        this.registerComponents(new IComponent[]{this.redstoneControl, this.energy});
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(energyBarParams, () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl)});
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this) && this.transferEnergy.autoExtract(this.level, this.worldPosition, this.orientation.outputDirection, MITweaksConfig.fluxTransformerMaxExtract)) {
            this.setChanged();
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        CapabilitiesListeners.register((String)"mi_tweaks", event -> {
            event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
                FluxTransformerBlockEntity machine = (FluxTransformerBlockEntity)((Object)((Object)be));
                return machine.orientation.outputDirection == direction ? null : machine.insertable;
            });
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, bet, (be, direction) -> {
                FluxTransformerBlockEntity machine = (FluxTransformerBlockEntity)((Object)((Object)be));
                return machine.orientation.outputDirection == direction ? machine.extractable : null;
            });
        });
    }
}

