/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.constantefficiency.hack;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import net.swedz.mi_tweaks.constantefficiency.hack.MachineEfficiencyHack;
import net.swedz.tesseract.neoforge.compat.mi.api.ActiveRecipeHolder;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccess;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccessBehavior;
import net.swedz.tesseract.neoforge.compat.mi.hook.context.machine.EfficiencyMIHookContext;
import net.swedz.tesseract.neoforge.compat.mi.hook.context.machine.MachineMIHookContext;

public final class AlwaysBaseMachineEfficiencyHack
implements MachineEfficiencyHack {
    private static long getBaseMachineEu(MachineBlockEntity machine) {
        if (machine instanceof CrafterComponentHolder) {
            CrafterComponentHolder crafterHolder = (CrafterComponentHolder)machine;
            return AlwaysBaseMachineEfficiencyHack.getBaseMachineEu(crafterHolder.getCrafterComponent());
        }
        throw new IllegalStateException("Efficiency hack was called for non crafter component holding machine (%s)".formatted(machine.getClass()));
    }

    private static long getBaseMachineEu(CrafterAccess crafter) {
        if (crafter instanceof ModularCrafterAccess) {
            ModularCrafterAccess modularCrafter = (ModularCrafterAccess)crafter;
            ModularCrafterAccessBehavior behavior = modularCrafter.getBehavior();
            return behavior.getBaseRecipeEu();
        }
        if (crafter instanceof CrafterComponent) {
            CrafterComponent crafterComponent = (CrafterComponent)crafter;
            CrafterComponent.Behavior behavior = crafterComponent.getBehavior();
            return behavior.getBaseRecipeEu();
        }
        throw new IllegalStateException("Unsupported crafter component type (%s)".formatted(crafter.getClass()));
    }

    private static long getRecipeMaxEu(long machineBaseEu, long machineMaxEu, long recipeEu, long totalEu, int efficiencyTicks) {
        long baseEu = Math.max(machineBaseEu, recipeEu);
        return Math.min(totalEu, Math.min((long)((int)Math.floor((double)baseEu * CrafterComponent.getEfficiencyOverclock((int)efficiencyTicks))), machineMaxEu));
    }

    private static int calculateEfficiencyTicks(long machineBaseEu, long machineMaxEu, long recipeEu, long totalEu, long targetEu) {
        long lastRecipeMaxEu = -1L;
        int ticks = 0;
        long recipeMaxEu;
        while ((recipeMaxEu = AlwaysBaseMachineEfficiencyHack.getRecipeMaxEu(machineBaseEu, machineMaxEu, recipeEu, totalEu, ticks)) != Math.min(targetEu, totalEu) && (targetEu <= lastRecipeMaxEu || targetEu >= recipeMaxEu)) {
            lastRecipeMaxEu = recipeMaxEu;
            ++ticks;
        }
        return ticks;
    }

    @Override
    public boolean constantEfficiency(EfficiencyMIHookContext context) {
        return true;
    }

    @Override
    public boolean preventsUpgrades(MachineMIHookContext context) {
        return false;
    }

    @Override
    public int getEfficiencyTicks(EfficiencyMIHookContext context) {
        long targetEu;
        long maxRecipeEu;
        long machineBaseEu;
        CrafterAccess crafter;
        MachineBlockEntity machine = context.getMachineBlockEntity();
        if (machine instanceof CrafterComponentHolder) {
            CrafterComponentHolder crafterHolder = (CrafterComponentHolder)machine;
            crafter = crafterHolder.getCrafterComponent();
            if (crafter instanceof ModularCrafterAccess) {
                ModularCrafterAccess modularCrafter = (ModularCrafterAccess)crafter;
                ModularCrafterAccessBehavior behavior = modularCrafter.getBehavior();
                machineBaseEu = behavior.getBaseRecipeEu();
                maxRecipeEu = behavior.getBaseMaxRecipeEu();
            } else if (crafter instanceof CrafterComponent) {
                CrafterComponent crafterComponent = (CrafterComponent)crafter;
                CrafterComponent.Behavior behavior = crafterComponent.getBehavior();
                machineBaseEu = behavior.getBaseRecipeEu();
                maxRecipeEu = behavior.getMaxRecipeEu();
            } else {
                throw new IllegalStateException("Unsupported crafter component type (%s) due to invalid CrafterAccess".formatted(crafter.getClass()));
            }
            if (!(crafter instanceof ActiveRecipeHolder)) {
                throw new IllegalStateException("Unsupported crafter component type (%s) due to lack of ActiveRecipeHolder".formatted(crafter.getClass()));
            }
        } else {
            throw new IllegalStateException("Efficiency hack was called for non crafter component holding machine (%s)".formatted(machine.getClass()));
        }
        ActiveRecipeHolder activeRecipeHolder = (ActiveRecipeHolder)crafter;
        long recipeEu = activeRecipeHolder.getRecipeEuCost(activeRecipeHolder.getActiveRecipe());
        long recipeTotalEu = activeRecipeHolder.getRecipeTotalEuCost(activeRecipeHolder.getActiveRecipe());
        long additionalEuFromUpgrades = (Long)machine.mapComponentOrDefault(UpgradeComponent.class, UpgradeComponent::getAddMaxEUPerTick, (Object)0L);
        long machineBaseMaxEu = maxRecipeEu - additionalEuFromUpgrades;
        if (recipeEu > machineBaseMaxEu) {
            long upgradesToExclude = recipeEu - machineBaseMaxEu;
            targetEu = recipeEu + additionalEuFromUpgrades - upgradesToExclude;
        } else {
            targetEu = Math.max(recipeEu, machineBaseEu) + additionalEuFromUpgrades;
        }
        return AlwaysBaseMachineEfficiencyHack.calculateEfficiencyTicks(machineBaseEu, maxRecipeEu, recipeEu, recipeTotalEu, targetEu);
    }

    @Override
    public long getMaxRecipeEu(EfficiencyMIHookContext context) {
        return context.getMaxRecipeEu();
    }
}

