/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.components.CasingComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.api.CableTierHolder;
import net.swedz.mi_tweaks.constantefficiency.ConstantEfficiencyHelper;
import net.swedz.mi_tweaks.constantefficiency.hack.MachineEfficiencyHackOption;
import net.swedz.mi_tweaks.item.MachineBlueprintItem;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class MITweaksTooltips {
    public static final TooltipAttachment MACHINE_HULL_AND_ENERGY_HATCH_VOLTAGE = TooltipAttachment.multilinesOptional((stack, item) -> {
        CableTier tier;
        MachineBlock machineBlock;
        MachineBlockEntity patt1$temp;
        BlockItem blockItem;
        Block patt0$temp;
        ArrayList lines = Lists.newArrayList();
        if (item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && (patt1$temp = (machineBlock = (MachineBlock)patt0$temp).getBlockEntityInstance()) instanceof EnergyHatch) {
            EnergyHatch energyHatch = (EnergyHatch)patt1$temp;
            tier = ((CableTierHolder)energyHatch).getCableTier();
        } else {
            tier = CasingComponent.getCasingTier((Item)item);
        }
        if (tier != null) {
            if (MITweaksConfig.displayMachineVoltage) {
                lines.add(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.MACHINE_VOLTAGE_RECIPES).arg((Object)Component.translatable((String)tier.shortEnglishKey())));
            }
            if (MITweaksConfig.efficiencyHack == MachineEfficiencyHackOption.USE_VOLTAGE) {
                lines.add(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.MACHINE_VOLTAGE_RUNS_AT).arg((Object)ConstantEfficiencyHelper.getRecipeEu(tier), MITooltips.EU_PER_TICK_PARSER));
            }
        }
        return lines.isEmpty() ? Optional.empty() : Optional.of(lines);
    });
    public static final TooltipAttachment MACHINE_BLUEPRINT_MISSING = TooltipAttachment.singleLineOptional((stack, item) -> {
        MachineBlock machineBlock;
        BlockItem blockItem;
        Block patt0$temp;
        Player player;
        TesseractProxy proxy = (TesseractProxy)Proxies.get(TesseractProxy.class);
        if (proxy.isClient() && (player = proxy.getClientPlayer()) != null && MITweaksConfig.machineBlueprintsRequiredTooltip.isEnabled() && item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && MITweaksConfig.machineBlueprintsMachines.contains((Block)(machineBlock = (MachineBlock)patt0$temp))) {
            return MachineBlueprintItem.hasBlueprint(player, (Block)machineBlock, MITweaksConfig.machineBlueprintsRequiredTooltip) ? Optional.empty() : Optional.of(MITweaksConfig.machineBlueprintsRequiredTooltip.tooltip().text().withStyle(ChatFormatting.RED));
        }
        return Optional.empty();
    }).noShiftRequired();
    public static final TooltipAttachment FLUX_TRANSFORMER = TooltipAttachment.multilines(List.of(MITweaks.id("flux_transformer")), List.of(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.FLUX_TRANSFORMER_HELP_1).arg((Object)MITweaksConfig.fluxTransformerConversionRate), MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.FLUX_TRANSFORMER_HELP_2).arg((Object)MITweaksConfig.fluxTransformerCableTier.shortEnglishName())));

    public static void init() {
    }
}

