/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.item.MachineBlueprintItem;
import net.swedz.mi_tweaks.item.renderer.BlockOverlayingItemRenderer;

@Mod(value="mi_tweaks", dist={Dist.CLIENT})
@EventBusSubscriber(value={Dist.CLIENT}, modid="mi_tweaks", bus=EventBusSubscriber.Bus.MOD)
public final class MITweaksClient {
    private static final ModelResourceLocation RAW_ITEM_MODEL_LOCATION = ModelResourceLocation.standalone((ResourceLocation)MITweaks.id("item/machine_blueprint_raw"));

    public MITweaksClient(IEventBus bus) {
        bus.addListener(RegisterClientExtensionsEvent.class, e -> e.registerItem(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new BlockOverlayingItemRenderer(RAW_ITEM_MODEL_LOCATION, MachineBlueprintItem::getMachineBlock);
            }
        }, new Item[]{MITweaksItems.MACHINE_BLUEPRINT.asItem()}));
    }

    @SubscribeEvent
    private static void init(FMLConstructModEvent __) {
        NeoForge.EVENT_BUS.addListener(ClientPlayerNetworkEvent.LoggingIn.class, e -> {
            if (!MITweaksConfig.machineBlueprintsLearning && (MITweaksConfig.machineBlueprintsRequiredTooltip.isLearning() || MITweaksConfig.machineBlueprintsRequiredForPlacing.isLearning() || MITweaksConfig.machineBlueprintsRequiredForRenderingHatches.isLearning())) {
                e.getPlayer().displayClientMessage((Component)MITweaksText.LEARNING_DISABLED_BUT_REQUIRING_LEARNING.text().withStyle(ChatFormatting.GOLD), false);
            }
        });
    }

    @SubscribeEvent
    private static void onModifyBakingResult(ModelEvent.RegisterAdditional event) {
        event.register(RAW_ITEM_MODEL_LOCATION);
    }
}

