/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.util;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerExtensionTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class ConnectedDrawers
implements INBTSerializable<CompoundTag> {
    private final StorageControllerTile<?> controllerTile;
    private List<Long> connectedDrawers;
    private List<IItemHandler> itemHandlers;
    private List<IFluidHandler> fluidHandlers;
    private Level level;
    private int extensions;
    private VoxelShape cachedVoxelShape;

    public ConnectedDrawers(Level level, StorageControllerTile<?> controllerTile) {
        this.controllerTile = controllerTile;
        this.connectedDrawers = new ArrayList<Long>();
        this.itemHandlers = new ArrayList<IItemHandler>();
        this.fluidHandlers = new ArrayList<IFluidHandler>();
        this.level = level;
        this.extensions = 0;
        this.cachedVoxelShape = null;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void rebuild() {
        this.itemHandlers = new ArrayList<IItemHandler>();
        this.fluidHandlers = new ArrayList<IFluidHandler>();
        this.extensions = 0;
        if (this.level != null && !this.level.isClientSide()) {
            int extraRange = this.controllerTile.getStorageMultiplier();
            if (extraRange == 1) {
                extraRange = 0;
            }
            AABB area = new AABB(this.controllerTile.getBlockPos()).inflate((double)(FunctionalStorageConfig.DRAWER_CONTROLLER_LINKING_RANGE + extraRange));
            this.connectedDrawers.removeIf(aLong -> !area.contains(Vec3.atCenterOf((Vec3i)BlockPos.of((long)aLong))));
            this.connectedDrawers.sort(Comparator.comparingDouble(value -> BlockPos.of((long)value).distSqr((Vec3i)this.controllerTile.getBlockPos())));
            for (Long connectedDrawer : this.connectedDrawers) {
                BlockPos pos = BlockPos.of((long)connectedDrawer);
                BlockEntity entity = this.level.getBlockEntity(pos);
                if (entity instanceof StorageControllerTile) continue;
                if (entity instanceof StorageControllerExtensionTile) {
                    ++this.extensions;
                    continue;
                }
                if (entity instanceof ItemControllableDrawerTile) {
                    ItemControllableDrawerTile itemControllableDrawerTile = (ItemControllableDrawerTile)entity;
                    this.itemHandlers.add(itemControllableDrawerTile.getStorage());
                }
                if (!(entity instanceof FluidDrawerTile)) continue;
                FluidDrawerTile fluidDrawerTile = (FluidDrawerTile)entity;
                this.fluidHandlers.add(fluidDrawerTile.getFluidHandler());
            }
        }
        this.controllerTile.inventoryHandler.invalidateSlots();
        this.controllerTile.fluidHandler.invalidateSlots();
    }

    public void rebuildShapes() {
        ArrayList<VoxelShape> mergedShapes;
        this.cachedVoxelShape = Shapes.create((AABB)new AABB(this.controllerTile.getBlockPos()));
        List<VoxelShape> currentShapes = this.connectedDrawers.stream().map(connectedDrawer -> Shapes.create((AABB)new AABB(BlockPos.of((long)connectedDrawer)))).toList();
        do {
            mergedShapes = new ArrayList<VoxelShape>();
            for (int i = 0; i < currentShapes.size(); i += 2) {
                VoxelShape shape1;
                VoxelShape mergedShape = shape1 = currentShapes.get(i);
                if (i + 1 < currentShapes.size()) {
                    VoxelShape shape2 = currentShapes.get(i + 1);
                    mergedShape = Shapes.joinUnoptimized((VoxelShape)shape1, (VoxelShape)shape2, (BooleanOp)BooleanOp.OR);
                }
                mergedShapes.add(mergedShape);
            }
        } while ((currentShapes = mergedShapes).size() > 1);
        if (currentShapes.size() == 1) {
            this.cachedVoxelShape = Shapes.joinUnoptimized((VoxelShape)this.cachedVoxelShape, (VoxelShape)currentShapes.get(0), (BooleanOp)BooleanOp.OR);
        }
        this.cachedVoxelShape = this.cachedVoxelShape.optimize();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        for (int i = 0; i < this.connectedDrawers.size(); ++i) {
            compoundTag.putLong("" + i, this.connectedDrawers.get(i).longValue());
        }
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.connectedDrawers = new ArrayList<Long>();
        for (String allKey : nbt.getAllKeys()) {
            this.connectedDrawers.add(nbt.getLong(allKey));
        }
        this.rebuild();
        if (this.controllerTile.getLevel() != null && this.controllerTile.isClient()) {
            this.rebuildShapes();
        }
    }

    public List<Long> getConnectedDrawers() {
        return this.connectedDrawers;
    }

    public List<IItemHandler> getItemHandlers() {
        return this.itemHandlers;
    }

    public List<IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    public int getExtensions() {
        return this.extensions;
    }

    public VoxelShape getCachedVoxelShape() {
        return this.cachedVoxelShape;
    }
}

