/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.util;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.recipe.CustomCompactingRecipe;
import com.buuz135.functionalstorage.util.StorageTags;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CompactingUtil {
    private final Level level;
    private List<Result> results;
    private final int resultAmount;
    private final List<CustomCompactingRecipe> recipes;

    public CompactingUtil(Level level, int resultAmount) {
        this.level = level;
        this.resultAmount = resultAmount;
        this.results = new ArrayList<Result>();
        this.recipes = RecipeUtil.getRecipes((Level)level, (RecipeType)((RecipeType)FunctionalStorage.CUSTOM_COMPACTING_RECIPE_TYPE.value()));
    }

    public void setup(ItemStack stack) {
        this.results.add(new Result(stack, 1));
        Result result = this.findUpperTier(stack);
        if (!result.getResult().isEmpty()) {
            this.results.add(result);
            if (this.results.size() < this.resultAmount && !(result = this.findUpperTier(result.getResult())).getResult().isEmpty()) {
                result.setNeeded(result.getNeeded() * this.results.get(this.results.size() - 1).getNeeded());
                this.results.add(result);
            }
        }
        boolean canFind = true;
        while (canFind && this.results.size() < this.resultAmount) {
            result = this.findLowerTier(this.results.get(0).getResult());
            if (!result.getResult().isEmpty()) {
                for (Result result12 : this.results) {
                    result12.setNeeded(result12.getNeeded() * result.getNeeded());
                }
                result.setNeeded(1);
                this.results.add(0, result);
                continue;
            }
            canFind = false;
        }
        while (this.results.size() < this.resultAmount) {
            this.results.add(0, new Result(ItemStack.EMPTY, 1));
        }
        this.results.stream().filter(result1 -> result1.getResult().getCount() > 0).forEach(result1 -> result1.setNeeded(result1.getNeeded() / result1.getResult().getCount()));
    }

    public List<Result> getResults() {
        return this.results;
    }

    private Result findUpperTier(ItemStack stack) {
        for (CustomCompactingRecipe recipe : this.recipes) {
            if (!ItemStack.isSameItem((ItemStack)recipe.lower_input, (ItemStack)stack)) continue;
            return new Result(recipe.higher_input.copyWithCount(1), recipe.lower_input.getCount());
        }
        int sizeCheck = 9;
        CraftingInput container = this.createContainerAndFill(3, stack);
        List<ItemStack> outputs = this.findAllMatchingRecipes(container);
        ArrayList<ItemStack> realOutputs = new ArrayList();
        if (outputs.size() == 0) {
            sizeCheck = 4;
            container = this.createContainerAndFill(2, stack);
            outputs = this.findAllMatchingRecipes(container);
        }
        if (stack.is(StorageTags.IGNORE_CRAFTING_CHECK)) {
            realOutputs = outputs;
        } else if (outputs.size() > 0) {
            for (ItemStack output : outputs) {
                container = this.createContainerAndFill(1, output);
                List<ItemStack> reversed = this.findAllMatchingRecipes(container);
                for (ItemStack reversedStack : reversed) {
                    if (reversedStack.getCount() != sizeCheck || !ItemStack.isSameItem((ItemStack)reversedStack, (ItemStack)stack)) continue;
                    realOutputs.add(output);
                }
            }
        }
        ItemStack similar = this.findSimilar(stack, realOutputs);
        if (!similar.isEmpty()) {
            return new Result(similar, sizeCheck);
        }
        if (realOutputs.size() > 0) {
            return new Result((ItemStack)realOutputs.get(0), sizeCheck);
        }
        return new Result(ItemStack.EMPTY, 0);
    }

    private Result findLowerTier(ItemStack stack) {
        for (CustomCompactingRecipe recipe : this.recipes) {
            if (!ItemStack.isSameItem((ItemStack)recipe.higher_input, (ItemStack)stack)) continue;
            return new Result(recipe.lower_input.copyWithCount(1), recipe.lower_input.getCount());
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> candidatesRate = new HashMap<ItemStack, Integer>();
        block1: for (RecipeHolder rcp : this.level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
            ItemStack match;
            CraftingRecipe craftingRecipe = (CraftingRecipe)rcp.value();
            ItemStack output = craftingRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
            if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)output) || (match = this.tryMatch(stack, (NonNullList<Ingredient>)craftingRecipe.getIngredients())).isEmpty()) continue;
            int recipeSize = craftingRecipe.getIngredients().size();
            if (stack.is(StorageTags.IGNORE_CRAFTING_CHECK)) {
                candidates.add(match);
                candidatesRate.put(match, recipeSize);
            }
            CraftingInput container = this.createContainerAndFill(1, output);
            List<ItemStack> matchStacks = this.findAllMatchingRecipes(container);
            for (ItemStack matchStack : matchStacks) {
                if (!ItemStack.isSameItem((ItemStack)match, (ItemStack)matchStack) || matchStack.getCount() != recipeSize) continue;
                candidates.add(match);
                candidatesRate.put(match, recipeSize);
                continue block1;
            }
        }
        ItemStack similar = this.findSimilar(stack, candidates);
        if (!similar.isEmpty()) {
            return new Result(similar, (Integer)candidatesRate.get(similar));
        }
        if (!candidates.isEmpty()) {
            return new Result(((ItemStack)candidates.get(0)).copy(), (Integer)candidatesRate.get(candidates.get(0)));
        }
        return new Result(ItemStack.EMPTY, 0);
    }

    private List<ItemStack> findAllMatchingRecipes(CraftingInput crafting) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (RecipeHolder rcp : this.level.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)crafting, this.level)) {
            ItemStack result;
            CraftingRecipe recipe = (CraftingRecipe)rcp.value();
            if (!recipe.matches((RecipeInput)crafting, this.level) || (result = recipe.assemble((RecipeInput)crafting, (HolderLookup.Provider)this.level.registryAccess())).isEmpty()) continue;
            candidates.add(result);
        }
        return candidates;
    }

    private ItemStack findSimilar(ItemStack reference, List<ItemStack> candidates) {
        ResourceLocation referenceName = BuiltInRegistries.ITEM.getKey((Object)reference.getItem());
        for (ItemStack candidate : candidates) {
            ResourceLocation matchName = BuiltInRegistries.ITEM.getKey((Object)candidate.getItem());
            if (!referenceName.getNamespace().equals(matchName.getNamespace())) continue;
            return candidate;
        }
        return !candidates.isEmpty() ? candidates.get(0) : ItemStack.EMPTY;
    }

    private ItemStack tryMatch(ItemStack stack, NonNullList<Ingredient> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return ItemStack.EMPTY;
        }
        Ingredient refIngredient = (Ingredient)ingredients.get(0);
        ItemStack[] refMatchingStacks = refIngredient.getItems();
        if (refMatchingStacks.length == 0) {
            return ItemStack.EMPTY;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            ItemStack match = ItemStack.EMPTY;
            for (ItemStack ingItemMatch : refMatchingStacks) {
                if (!ingredient.test(ingItemMatch)) continue;
                match = ingItemMatch;
                break;
            }
            if (!match.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        ItemStack match = this.findSimilar(stack, Arrays.asList(refMatchingStacks));
        if (match.isEmpty()) {
            match = refMatchingStacks[0];
        }
        return match;
    }

    private CraftingInput createContainerAndFill(int size, ItemStack stack) {
        return CraftingInput.of((int)size, (int)size, IntStream.range(0, size * size).mapToObj(i -> stack.copy()).toList());
    }

    public static class Result {
        private ItemStack result;
        private int needed;

        public Result(ItemStack result, int needed) {
            this.result = result;
            this.needed = needed;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public void setResult(ItemStack result) {
            this.result = result;
        }

        public int getNeeded() {
            return this.needed;
        }

        public void setNeeded(int needed) {
            this.needed = needed;
        }

        public String toString() {
            return "Result{result=" + String.valueOf(this.result) + ", needed=" + this.needed + "}";
        }
    }
}

