/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.EnderDrawerTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.item.BasicItem;
import com.mojang.serialization.Codec;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class LinkingToolItem
extends BasicItem {
    public static LinkingMode getLinkingMode(ItemStack stack) {
        return (LinkingMode)((Object)stack.getOrDefault(FSAttachments.LINKING_MODE, (Object)LinkingMode.SINGLE));
    }

    public static ActionMode getActionMode(ItemStack stack) {
        return (ActionMode)((Object)stack.getOrDefault(FSAttachments.ACTION_MODE, (Object)ActionMode.ADD));
    }

    public LinkingToolItem() {
        super(new Item.Properties().stacksTo(1));
        this.setItemGroup(FunctionalStorage.TAB);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(FSAttachments.ENDER_FREQUENCY);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EnderDrawerTile) {
            EnderDrawerTile tile = (EnderDrawerTile)blockEntity;
            stack.set(FSAttachments.ENDER_FREQUENCY, (Object)tile.getFrequency());
            player.displayClientMessage((Component)Component.literal((String)"Stored frequency in the tool").setStyle(Style.EMPTY.withColor(LinkingMode.SINGLE.color)), true);
            return false;
        }
        return super.canAttackBlock(state, level, pos, player);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity controller;
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
        ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
        if (blockEntity instanceof EnderDrawerTile && stack.has(FSAttachments.ENDER_FREQUENCY)) {
            String frequency = (String)stack.get(FSAttachments.ENDER_FREQUENCY);
            EnderInventoryHandler inventory = EnderSavedData.getInstance((LevelAccessor)context.getLevel()).getFrequency(((EnderDrawerTile)blockEntity).getFrequency());
            if (inventory.getStackInSlot(0).isEmpty() || context.getPlayer().isShiftKeyDown() && stack.has(FSAttachments.ENDER_SAFETY)) {
                ((EnderDrawerTile)blockEntity).setFrequency(frequency);
                context.getPlayer().displayClientMessage((Component)Component.literal((String)"Changed drawer frequency").setStyle(Style.EMPTY.withColor(linkingMode.color)), true);
                stack.remove(FSAttachments.ENDER_SAFETY);
            } else {
                context.getPlayer().displayClientMessage((Component)Component.literal((String)"Cannot change frequency, there are items in the drawer. Sneak + Right Click again to ignore this safety").withStyle(ChatFormatting.RED), true);
                stack.set(FSAttachments.ENDER_SAFETY, (Object)Unit.INSTANCE);
            }
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof StorageControllerTile) {
            stack.set(FSAttachments.CONTROLLER, (Object)pos);
            context.getPlayer().playSound(SoundEvents.ITEM_FRAME_ADD_ITEM, 0.5f, 1.0f);
            context.getPlayer().displayClientMessage((Component)Component.literal((String)"Controller configured to the tool").withStyle(ChatFormatting.GREEN), true);
            stack.remove(FSAttachments.ENDER_FREQUENCY);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof ControllableDrawerTile && stack.has(FSAttachments.CONTROLLER) && (controller = level.getBlockEntity((BlockPos)stack.get(FSAttachments.CONTROLLER))) instanceof StorageControllerTile) {
            if (linkingMode == LinkingMode.SINGLE) {
                if (((StorageControllerTile)controller).addConnectedDrawers(linkingAction, pos)) {
                    if (linkingAction == ActionMode.ADD) {
                        context.getPlayer().displayClientMessage((Component)Component.literal((String)"Linked drawer to the controller").setStyle(Style.EMPTY.withColor(linkingMode.color)), true);
                    } else {
                        context.getPlayer().displayClientMessage((Component)Component.literal((String)"Removed drawer from the controller").setStyle(Style.EMPTY.withColor(linkingMode.color)), true);
                    }
                }
            } else if (stack.has(FSAttachments.FIRST_POSITION)) {
                BlockPos firstPos = (BlockPos)stack.get(FSAttachments.FIRST_POSITION);
                AABB aabb = new AABB((double)Math.min(firstPos.getX(), pos.getX()), (double)Math.min(firstPos.getY(), pos.getY()), (double)Math.min(firstPos.getZ(), pos.getZ()), (double)(Math.max(firstPos.getX(), pos.getX()) + 1), (double)(Math.max(firstPos.getY(), pos.getY()) + 1), (double)(Math.max(firstPos.getZ(), pos.getZ()) + 1));
                if (((StorageControllerTile)controller).addConnectedDrawers(linkingAction, (BlockPos[])LinkingToolItem.getBlockPosInAABB(aabb).toArray(BlockPos[]::new))) {
                    if (linkingAction == ActionMode.ADD) {
                        context.getPlayer().displayClientMessage((Component)Component.literal((String)"Linked drawers to the controller").setStyle(Style.EMPTY.withColor(linkingMode.color)), true);
                    } else {
                        context.getPlayer().displayClientMessage((Component)Component.literal((String)"Removed drawers from the controller").setStyle(Style.EMPTY.withColor(linkingMode.color)), true);
                    }
                }
                stack.remove(FSAttachments.FIRST_POSITION);
            } else {
                stack.set(FSAttachments.FIRST_POSITION, (Object)pos);
            }
            context.getPlayer().playSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level p_41432_, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty()) {
            if (stack.has(FSAttachments.ENDER_FREQUENCY)) {
                if (player.isShiftKeyDown()) {
                    stack.remove(FSAttachments.ENDER_FREQUENCY);
                    player.displayClientMessage((Component)Component.literal((String)"Cleared drawer frequency").setStyle(Style.EMPTY.withColor(ActionMode.ADD.getColor())), true);
                }
            } else if (player.isShiftKeyDown()) {
                LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
                LinkingMode newMode = linkingMode == LinkingMode.SINGLE ? LinkingMode.MULTIPLE : LinkingMode.SINGLE;
                stack.set(FSAttachments.LINKING_MODE, (Object)newMode);
                player.displayClientMessage((Component)Component.literal((String)("Swapped mode to " + newMode.name().toLowerCase(Locale.ROOT))).setStyle(Style.EMPTY.withColor(LinkingMode.MULTIPLE.getColor())), true);
                stack.remove(FSAttachments.FIRST_POSITION);
            } else {
                ActionMode linkingMode = LinkingToolItem.getActionMode(stack);
                ActionMode newMode = linkingMode == ActionMode.ADD ? ActionMode.REMOVE : ActionMode.ADD;
                stack.set(FSAttachments.ACTION_MODE, (Object)newMode);
                player.displayClientMessage((Component)Component.literal((String)("Swapped action to " + newMode.name().toLowerCase(Locale.ROOT))).setStyle(Style.EMPTY.withColor(ActionMode.REMOVE.getColor())), true);
            }
            player.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 0.5f, 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(p_41432_, player, hand);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
        ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
        if (key == null) {
            if (stack.has(FSAttachments.ENDER_FREQUENCY)) {
                MutableComponent text = Component.translatable((String)"linkingtool.ender.frequency");
                tooltip.add((Component)text.withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.literal((String)""));
                tooltip.add((Component)Component.literal((String)""));
                tooltip.add((Component)Component.translatable((String)"linkingtool.ender.clear").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"linkingtool.linkingmode").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)("linkingtool.linkingmode." + linkingMode.name().toLowerCase(Locale.ROOT))).withStyle(Style.EMPTY.withColor(linkingMode.getColor()))));
                tooltip.add((Component)Component.translatable((String)"linkingtool.linkingaction").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)("linkingtool.linkingaction." + linkingAction.name().toLowerCase(Locale.ROOT))).withStyle(Style.EMPTY.withColor(linkingAction.getColor()))));
                if (stack.has(FSAttachments.CONTROLLER)) {
                    BlockPos pos = (BlockPos)stack.get(FSAttachments.CONTROLLER);
                    tooltip.add((Component)Component.translatable((String)"linkingtool.controller").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)(pos.getX() + String.valueOf(ChatFormatting.WHITE) + ", " + String.valueOf(ChatFormatting.DARK_AQUA) + pos.getY() + String.valueOf(ChatFormatting.WHITE) + ", " + String.valueOf(ChatFormatting.DARK_AQUA) + pos.getZ())).withStyle(ChatFormatting.DARK_AQUA)));
                } else {
                    tooltip.add((Component)Component.translatable((String)"linkingtool.controller").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"???").withStyle(ChatFormatting.DARK_AQUA)));
                }
                tooltip.add((Component)Component.literal((String)""));
                tooltip.add((Component)Component.translatable((String)("linkingtool.linkingmode." + linkingMode.name().toLowerCase(Locale.ROOT) + ".desc")).withStyle(ChatFormatting.GRAY));
                tooltip.add((Component)Component.translatable((String)"linkingtool.use").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public static List<BlockPos> getBlockPosInAABB(AABB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.minY; y < axisAlignedBB.maxY; y += 1.0) {
            for (double x = axisAlignedBB.minX; x < axisAlignedBB.maxX; x += 1.0) {
                for (double z = axisAlignedBB.minZ; z < axisAlignedBB.maxZ; z += 1.0) {
                    blocks.add(new BlockPos((int)x, (int)y, (int)z));
                }
            }
        }
        return blocks;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    static {
        EventManager.forge(PlayerInteractEvent.LeftClickBlock.class).filter(leftClickBlock -> leftClickBlock.getSide() == LogicalSide.SERVER && leftClickBlock.getItemStack().is((Item)FunctionalStorage.LINKING_TOOL.get())).process(leftClickBlock -> {
            ItemStack stack = leftClickBlock.getItemStack();
            BlockEntity blockEntity = leftClickBlock.getLevel().getBlockEntity(leftClickBlock.getPos());
            if (blockEntity instanceof EnderDrawerTile) {
                EnderDrawerTile tile = (EnderDrawerTile)blockEntity;
                stack.set(FSAttachments.ENDER_FREQUENCY, (Object)tile.getFrequency());
                leftClickBlock.getEntity().displayClientMessage((Component)Component.literal((String)"Stored frequency in the tool").setStyle(Style.EMPTY.withColor(LinkingMode.SINGLE.color)), true);
                leftClickBlock.setCanceled(true);
            }
        }).subscribe();
    }

    public static enum LinkingMode implements StringRepresentable
    {
        SINGLE(TextColor.fromRgb((int)Color.cyan.getRGB())),
        MULTIPLE(TextColor.fromRgb((int)Color.GREEN.getRGB()));

        public static final Codec<LinkingMode> CODEC;
        private final TextColor color;

        private LinkingMode(TextColor color) {
            this.color = color;
        }

        public TextColor getColor() {
            return this.color;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(LinkingMode::values);
        }
    }

    public static enum ActionMode implements StringRepresentable
    {
        ADD(TextColor.fromRgb((int)new Color(40, 131, 250).getRGB())),
        REMOVE(TextColor.fromRgb((int)new Color(250, 145, 40).getRGB()));

        public static final Codec<ActionMode> CODEC;
        private final TextColor color;

        private ActionMode(TextColor color) {
            this.color = color;
        }

        public TextColor getColor() {
            return this.color;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(ActionMode::values);
        }
    }
}

