/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.hrznstudio.titanium.item.BasicItem;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ConfigurationToolItem
extends BasicItem {
    public static ConfigurationAction getAction(ItemStack stack) {
        return (ConfigurationAction)((Object)stack.getOrDefault(FSAttachments.CONFIGURATION_ACTION, (Object)ConfigurationAction.LOCKING));
    }

    public ConfigurationToolItem() {
        super(new Item.Properties().stacksTo(1));
        this.setItemGroup(FunctionalStorage.TAB);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        ConfigurationAction configuractionAction = ConfigurationToolItem.getAction(stack);
        if (blockEntity instanceof ControllableDrawerTile) {
            if (configuractionAction == ConfigurationAction.LOCKING) {
                ((ControllableDrawerTile)blockEntity).toggleLocking();
            } else {
                ((ControllableDrawerTile)blockEntity).toggleOption(configuractionAction);
                if (configuractionAction.getMax() > 1) {
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)("configurationtool.configmode.indicator.mode_" + ((ControllableDrawerTile)blockEntity).getDrawerOptions().getAdvancedValue(configuractionAction))).setStyle(Style.EMPTY.withColor(configuractionAction.getColor())), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level p_41432_, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && player.isShiftKeyDown()) {
            ConfigurationAction action = ConfigurationToolItem.getAction(stack);
            ConfigurationAction newAction = ConfigurationAction.values()[(Arrays.asList(ConfigurationAction.values()).indexOf((Object)action) + 1) % ConfigurationAction.values().length];
            stack.set(FSAttachments.CONFIGURATION_ACTION, (Object)newAction);
            player.displayClientMessage((Component)Component.literal((String)"Swapped mode to ").setStyle(Style.EMPTY.withColor(newAction.getColor())).append((Component)Component.translatable((String)("configurationtool.configmode." + newAction.name().toLowerCase(Locale.ROOT)))), true);
            player.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 0.5f, 1.0f);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(p_41432_, player, hand);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        ConfigurationAction linkingMode = ConfigurationToolItem.getAction(stack);
        if (key == null) {
            tooltip.add((Component)Component.translatable((String)"configurationtool.configmode").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)("configurationtool.configmode." + linkingMode.name().toLowerCase(Locale.ROOT))).withStyle(Style.EMPTY.withColor(linkingMode.getColor()))));
            tooltip.add((Component)Component.literal((String)"").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"configurationtool.use").withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public static enum ConfigurationAction implements StringRepresentable
    {
        LOCKING(TextColor.fromRgb((int)FastColor.ARGB32.color((int)40, (int)131, (int)250)), 1),
        TOGGLE_NUMBERS(TextColor.fromRgb((int)FastColor.ARGB32.color((int)250, (int)145, (int)40)), 1),
        TOGGLE_RENDER(TextColor.fromRgb((int)FastColor.ARGB32.color((int)100, (int)250, (int)40)), 1),
        TOGGLE_UPGRADES(TextColor.fromRgb((int)FastColor.ARGB32.color((int)166, (int)40, (int)250)), 1),
        INDICATOR(TextColor.fromRgb((int)FastColor.ARGB32.color((int)255, (int)40, (int)40)), 3);

        public static final Codec<ConfigurationAction> CODEC;
        private final TextColor color;
        private final int max;

        private ConfigurationAction(TextColor color, int max) {
            this.color = color;
            this.max = max;
        }

        public TextColor getColor() {
            return this.color;
        }

        public int getMax() {
            return this.max;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(ConfigurationAction::values);
        }
    }
}

