/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class DrawerStackItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private List<BigInventoryHandler.BigStack> storedStacks;
    private ItemStack stack;
    private FunctionalStorage.DrawerType type;
    private int multiplier;
    private boolean downgrade;
    private boolean isVoid;
    private boolean isCreative;

    public DrawerStackItemHandler(ItemStack stack, FunctionalStorage.DrawerType drawerType) {
        this.stack = stack;
        this.storedStacks = new ArrayList<BigInventoryHandler.BigStack>();
        this.type = drawerType;
        this.multiplier = 1;
        this.downgrade = false;
        this.isVoid = false;
        this.isCreative = false;
        for (int i = 0; i < drawerType.getSlots(); ++i) {
            this.storedStacks.add(i, new BigInventoryHandler.BigStack(ItemStack.EMPTY, 0));
        }
        if (stack.has(FSAttachments.TILE)) {
            ItemStack itemStack;
            CompoundTag tile = (CompoundTag)stack.get(FSAttachments.TILE);
            this.isCreative = tile.contains("isCreative") && tile.getBoolean("isCreative");
            RegistryAccess access = Utils.registryAccess();
            this.deserializeNBT((HolderLookup.Provider)access, tile.getCompound("handler"));
            for (Tag tag : tile.getCompound("storageUpgrades").getList("Items", 10)) {
                itemStack = Utils.deserialize((HolderLookup.Provider)access, (CompoundTag)tag);
                if (itemStack.getItem() instanceof StorageUpgradeItem) {
                    this.multiplier = this.multiplier == 1 ? ((StorageUpgradeItem)itemStack.getItem()).getStorageMultiplier() : (this.multiplier *= ((StorageUpgradeItem)itemStack.getItem()).getStorageMultiplier());
                }
                if (!itemStack.getItem().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) continue;
                this.downgrade = true;
            }
            for (Tag tag : tile.getCompound("utilityUpgrades").getList("Items", 10)) {
                itemStack = Utils.deserialize((HolderLookup.Provider)access, (CompoundTag)tag);
                if (!itemStack.getItem().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.storedStacks.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.put(BigInventoryHandler.STACK, this.storedStacks.get(i).getStack().saveOptional(provider));
            bigStack.putInt(BigInventoryHandler.AMOUNT, this.storedStacks.get(i).getAmount());
            items.put("" + i, (Tag)bigStack);
        }
        compoundTag.put(BigInventoryHandler.BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        for (String allKey : nbt.getCompound(BigInventoryHandler.BIG_ITEMS).getAllKeys()) {
            this.storedStacks.get(Integer.parseInt(allKey)).setStack(Utils.deserialize(provider, nbt.getCompound(BigInventoryHandler.BIG_ITEMS).getCompound(allKey).getCompound(BigInventoryHandler.STACK)));
            this.storedStacks.get(Integer.parseInt(allKey)).setAmount(nbt.getCompound(BigInventoryHandler.BIG_ITEMS).getCompound(allKey).getInt(BigInventoryHandler.AMOUNT));
        }
    }

    public int getSlots() {
        return this.type.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
        if (this.isCreative) {
            return bigStack.getStack().copyWithCount(Integer.MAX_VALUE);
        }
        ItemStack copied = bigStack.getStack().copy();
        copied.setCount(bigStack.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isValid(slot, stack)) {
            BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) - bigStack.getAmount(), stack.getCount());
            if (!simulate) {
                bigStack.setStack(stack);
                bigStack.setAmount(Math.min(bigStack.getAmount() + inserted, this.getSlotLimit(slot)));
                this.onChange();
            }
            if (inserted == stack.getCount() || this.isVoid()) {
                return ItemStack.EMPTY;
            }
            return stack.copyWithCount(stack.getCount() - inserted);
        }
        return stack;
    }

    private boolean isVoid() {
        return true;
    }

    private void onChange() {
        this.stack.set(FSAttachments.TILE, (Object)new CompoundTag());
        ((CompoundTag)this.stack.get(FSAttachments.TILE)).put("handler", (Tag)this.serializeNBT((HolderLookup.Provider)Utils.registryAccess()));
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.type.getSlots()) {
            BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
            ItemStack fl = bigStack.getStack();
            return fl.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        if (slot < this.type.getSlots()) {
            BigInventoryHandler.BigStack bigStack = this.storedStacks.get(slot);
            if (bigStack.getStack().isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (bigStack.getAmount() <= amount) {
                ItemStack out = bigStack.getStack().copy();
                int newAmount = bigStack.getAmount();
                if (!simulate) {
                    if (!this.isLocked()) {
                        bigStack.setStack(ItemStack.EMPTY);
                    }
                    bigStack.setAmount(0);
                    this.onChange();
                }
                out.setCount(newAmount);
                return out;
            }
            if (!simulate) {
                bigStack.setAmount(bigStack.getAmount() - amount);
                this.onChange();
            }
            return bigStack.getStack().copyWithCount(amount);
        }
        return ItemStack.EMPTY;
    }

    public boolean isLocked() {
        return true;
    }

    public int getSlotLimit(int slot) {
        if (this.isCreative) {
            return Integer.MAX_VALUE;
        }
        int slotAmount = this.type.getSlotAmount();
        if (this.hasDowngrade()) {
            slotAmount = 64;
        }
        return (int)Math.min(Integer.MAX_VALUE, (long)slotAmount * this.getMultiplier());
    }

    private long getMultiplier() {
        return this.multiplier;
    }

    private boolean hasDowngrade() {
        return this.downgrade;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.isEmpty();
    }

    public List<BigInventoryHandler.BigStack> getStoredStacks() {
        return this.storedStacks;
    }

    public boolean isCreative() {
        return this.isCreative;
    }
}

